/*!

Doctests not part of the documentation are used instead of “normal” tests
because they support expecting a compilation error with `compile_fail`.

## Good

```
use bytes_cast::*;
#[derive(BytesCast)]
#[repr(C)]
struct Example {}

#[derive(BytesCast)]
#[repr(C)]
struct Example2(
    u8,
    unaligned::U32Be,
);
```

## Bad

```compile_fail
use bytes_cast::*;
#[derive(BytesCast)]
#[repr(C)]
enum NotAStruct {
    A,
    B,
}
```

```compile_fail
use bytes_cast::*;
#[derive(BytesCast)]
struct NoReprAttribute {}
```

```compile_fail
use bytes_cast::*;
#[derive(BytesCast)]
#[repr(C)]
struct Generic<T>(T);
```

```compile_fail
use bytes_cast::*;
#[derive(BytesCast)]
#[repr(C)]
struct FieldIsNotBytesCast(
    u8,
    u32,
);
```

```compile_fail
use bytes_cast::*;
#[derive(BytesCast)]
#[repr(C)]
#[repr(align(2))]
struct HasAlignmentRequirement {}
```

*/
