//////////////////////////////////////////////////////////////////////////////
//
// 		  Copyright (C) 1996,1997  Matthew Doar  doar@pobox.com
// 
// Permission to use, copy, and distribute this software and its documentation 
// for any purpose with or without fee is hereby granted, provided that the 
// above copyright notice appears with all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// 
// Permission to modify the software is granted, but not the right to 
// distribute the modified code. Modifications are to be distributed as 
// patches to the released version. 
// 
// This software is provided "as is" without express or implied warranty. 
//
//////////////////////////////////////////////////////////////////////////////

// tiers_main.cc

#include <iostream.h>
#include <stdlib.h>	// for strtoul
#include <math.h>		// for random

#ifndef _TIERS_HH
#include "tiers.hh"
#endif

extern "C" 
{
  long int time(int dummy);
  char * initstate(unsigned seed, char *state, int n);
}

unsigned long int NW;	// maximum number of WANs, currently 1
unsigned long int NM;	// maximum number of MANs per WAN
unsigned long int NL;	// maximum number of LANs per MAN

unsigned long int SW;	// maximum number of nodes per WAN
unsigned long int SM;	// maximum number of nodes per MAN
unsigned long int SL;	// maximum number of nodes per LAN

unsigned long int RW;	// intranetwork redundancy for WANs
unsigned long int RM;	// intranetwork redundancy for MANs
unsigned long int RL;	// intranetwork redundancy for LANs

unsigned long int RMW;	// internetwork redundancy for MAN to WAN connections
unsigned long int RLM;	// internetwork redundancy for LAN to MAN connections



////////////////////////////////////////////////////////////////////////
// ProcessArgs
//
// Check inputs - may want to read a partial graph. TODO
// Display help file
// Fill in the model parameters
////////////////////////////////////////////////////////////////////////
bool ProcessArgs(int argc, char* argv[])
{
  bool ret = true;

  cerr.setf( ios::unitbuf );
  cout.setf( ios::unitbuf );

// TIERS_VERBOSE
#ifdef 0 
  cout << "Main:: Processing arguments. Arguments are:"
       << endl;
  for (int i = 0; i < argc; i++)
	{
	  cout << "\t" << i << ": '" << argv[i] << "'"
		   << endl;
	}
#endif
  
  switch (argc)
	{ 
	case 13:
	  {
		NW = strtoul(argv[1], NULL, 0);
		NM = strtoul(argv[2], NULL, 0);
		NL = strtoul(argv[3], NULL, 0);
		SW = strtoul(argv[4], NULL, 0);
		SM = strtoul(argv[5], NULL, 0);
		SL = strtoul(argv[6], NULL, 0);
		RW = strtoul(argv[7], NULL, 0);
		RM = strtoul(argv[8], NULL, 0);
		RL = strtoul(argv[9], NULL, 0);
		RMW = strtoul(argv[10], NULL, 0);
		RLM= strtoul(argv[11], NULL, 0);
		ModelId = strtoul(argv[12], NULL, 0);
		break;
	  }
	case 8:
	  {

		NW = strtoul(argv[1], NULL, 0);
		NM = strtoul(argv[2], NULL, 0);
		NL = strtoul(argv[3], NULL, 0);
		SW = strtoul(argv[4], NULL, 0);
		SM = strtoul(argv[5], NULL, 0);
		SL = strtoul(argv[6], NULL, 0);
		ModelId = strtoul(argv[7], NULL, 0);
		RW = 1;
		RM = 1;
		RL = 1;
		RMW = 1;
		RLM= 1;
		break;
	  }
	default:	
	  {
		cout << endl << "Usage:\t"
			 << "tiers NW NM NL SW SM SL RW RM RL RMW RLM ModelId" << endl << endl

			 << "\tNW: maximum number of WANs (currently only 1 supported)" << endl
			 << "\tNM: maximum number of MANs per WAN" << endl
			 << "\tNL: maximum number of LANs per MAN" << endl
			 << "\tSW: maximum number of nodes per WAN" << endl
			 << "\tSM: maximum number of nodes per MAN" << endl
			 << "\tSL: maximum number of nodes per LAN" << endl << endl

			 << "Optional parameters:" << endl << endl

			 << "\tRW: intranetwork redundancy for WAN (default 1)" << endl
			 << "\tRM: intranetwork redundancy for MANs (default 1)" << endl
			 << "\tRL: intranetwork redundancy for LANs (currently only 1 supported)" << endl
			 << "\tRMW: internetwork redundancy for MAN to WAN (default 1)" << endl
			 << "\tRLM: internetwork redundancy for LAN to MAN (default 1)" << endl
			 << "\tModelId: Model ID used for random generation" << endl
			 << endl;
		ret = false;
		break;
	  } // case
	} // switch

  //
  // Check the validity of the parameters
  //
  if ((NW != 1) && (argc > 1))
	{
	  cout << "Tiers:: Only 1 WAN currently supported" << endl;
	  return false;
	}

  if ((RL != 1) && (argc > 1))
	{
	  cout << "Tiers:: LAN redundancy currently not supported" << endl;
	  return false;
	}

  return ret;
}



////////////////////////////////////////////////////////////////////////
// main
//
// Start point for the network model
////////////////////////////////////////////////////////////////////////
int
main(int argc, char *argv[])
{
  char    randstate[32];
  ModelId = time(0); // If models are created quickly, this may not be unique

  //initstate(ModelId, randstate, 32); 
  // initstate(938346465, randstate, 32); // a deterministic set of values
  
  if (!ProcessArgs(argc, argv)) 
	{
	  //	  cerr << "Main:: Error reading arguments" << endl;
	}
  else
	{
	  Model *theModel = new Model;
	  if (!theModel) 
		{
		  cerr << "Main:: Error allocating model" << endl;
		  abort();
		}
	initstate(ModelId, randstate, 32);

	  // Read in the configuration for the model (not the parameters)
	  if (!theModel->ProcessConfig())
		{
		  cerr << "Main:: Error reading model configuration" << endl;
		  abort();
		}


#if 0 
	  // The creation of the cost table is now done by reading the values 
	  // directly from the configuration file
	  CostTableEntry	simple = {10,0,1};
	  CostTableEntry	StaticCostTable[] = { simple,simple,simple,
	  										  simple,simple,simple,
	  										  simple,simple,simple };
#endif
  
	  // Create the cost table for the model
	  if (!theModel->CreateCostTable(/*StaticCostTable*/))
		{
		  cerr << "Main:: Error creating cost table" << endl;
		  abort();
		}

	  // Create the model itself
	  if (!theModel->CreateModel(NW,NM,NL,
								 SW,SM,SL,
								 RW,RM,RL,
								 RMW,RLM)) 
		{
		  cerr << "Main:: Error creating model" << endl;
		  abort();
		}

	  // Output the model as nodes and edges
	  if (!theModel->OutputModel(OP_TYPE)) 
		{
		  cerr << "Main:: Error outputing model" << endl;
		  abort();
		}

	  // Delete the model
	  // delete theModel; // this is done already in smaller parts
	}
}

// end of file
