/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeriesDouble;

public class SimpleLocalEstimator {
    private final double yearFraction;

    public SimpleLocalEstimator(double y) {
        this.yearFraction = y;
    }

    public TimeSeriesDouble calculate(TimeSeriesDouble quoteSeries) {
        Date[] dates = quoteSeries.dates();
        double[] values = quoteSeries.values();
        TimeSeriesDouble retval = new TimeSeriesDouble();
        Double prev = null;
        Double cur = null;
        for (int i = 1; i < values.length; ++i) {
            cur = values[i];
            prev = values[i - 1];
            double s = Math.abs(Math.log(cur / prev)) / Math.sqrt(this.yearFraction);
            retval.add(dates[i], s);
        }
        return retval;
    }
}

