/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.factories.BackwardFlat;
import org.jquantlib.termstructures.yieldcurves.ForwardRateStructure;
import org.jquantlib.termstructures.yieldcurves.YieldCurve;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.util.Date;
import org.jquantlib.util.Pair;

public final class InterpolatedForwardCurve<T extends Interpolator>
extends ForwardRateStructure
implements YieldCurve {
    protected Date[] dates;
    protected double[] times;
    protected double[] data;
    protected Interpolation interpolation;
    protected boolean isNegativeRates;
    private Interpolator interpolator;

    protected InterpolatedForwardCurve(DayCounter dayCounter, T interpolator) {
        super(dayCounter);
        this.interpolator = interpolator != null ? interpolator : new BackwardFlat();
        throw new UnsupportedOperationException("Work in progress");
    }

    protected InterpolatedForwardCurve(Date referenceDate, DayCounter dayCounter, T interpolator) {
        super(referenceDate, (Calendar)Target.getCalendar(), dayCounter);
        this.interpolator = interpolator != null ? interpolator : new BackwardFlat();
        throw new UnsupportedOperationException("Work in progress");
    }

    protected InterpolatedForwardCurve(int settlementDays, Calendar calendar, DayCounter dayCounter, T interpolator) {
        super(settlementDays, calendar, dayCounter);
        this.interpolator = interpolator != null ? interpolator : new BackwardFlat();
        throw new UnsupportedOperationException("Work in progress");
    }

    public InterpolatedForwardCurve(Date[] dates, double[] forwards, DayCounter dayCounter, T interpolator) {
        super(dates[0], (Calendar)Target.getCalendar(), dayCounter);
        throw new UnsupportedOperationException("Work in progress");
    }

    @Override
    public final Date[] getDates() {
        return (Date[])this.dates.clone();
    }

    @Override
    public final double[] getData() {
        return (double[])this.data.clone();
    }

    @Override
    public final Date maxDate() {
        return this.dates[this.dates.length - 1];
    }

    @Override
    public final Pair<Date, Double>[] getNodes() {
        Pair[] results = new Pair[this.dates.length];
        for (int i = 0; i < this.dates.length; ++i) {
            results[i] = new Pair<Date, Double>(this.dates[i], this.data[i]);
        }
        return results;
    }

    @Override
    public final double[] getTimes() {
        return (double[])this.times.clone();
    }

    @Override
    public double forwardImpl(double t) {
        return this.interpolation.evaluate(t, true);
    }

    @Override
    public double zeroYieldImpl(double t) {
        if (t == 0.0) {
            return this.forwardImpl(0.0);
        }
        return this.interpolation.primitive(t, true) / t;
    }
}

