/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation2D;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.interpolations.Interpolator2D;

public class BilinearInterpolation
extends AbstractInterpolation2D {
    private BilinearInterpolation() {
    }

    public static Interpolator2D getInterpolator() {
        BilinearInterpolation bilinearInterpolation = new BilinearInterpolation();
        return new BilinearInterpolationImpl(bilinearInterpolation);
    }

    @Override
    public double evaluateImpl(double x, double y) {
        int i = this.locateX(x);
        int j = this.locateY(y);
        double z1 = this.mz[j][i];
        double z2 = this.mz[j][i + 1];
        double z3 = this.mz[j + 1][i];
        double z4 = this.mz[j + 1][i + 1];
        double t = (x - this.vx[i]) / (this.vx[i + 1] - this.vx[i]);
        double u = (y - this.vy[j]) / (this.vy[j + 1] - this.vy[j]);
        return (1.0 - t) * (1.0 - u) * z1 + t * (1.0 - u) * z2 + (1.0 - t) * u * z3 + t * u * z4;
    }

    private static class BilinearInterpolationImpl
    implements Interpolator2D {
        private BilinearInterpolation delegate;

        public BilinearInterpolationImpl(BilinearInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public Interpolation2D interpolate(double[] x, double[] y, double[][] z) {
            this.delegate.vx = x;
            this.delegate.vy = y;
            this.delegate.mz = z;
            this.delegate.reload();
            return this.delegate;
        }
    }
}

