/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Mexico
extends DelegateCalendar {
    private static final Mexico SETTLEMENT_CALENDAR = new Mexico(Market.SETTLEMENT);
    private static final Mexico BMV_CALENDAR = new Mexico(Market.BMV);

    private Mexico(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new MexicoSettlementCalendar();
                break;
            }
            case BMV: {
                delegate = new BMVExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Mexico getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case BMV: {
                return BMV_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class BMVExchangeCalendar
    extends WesternCalendar {
        private BMVExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "Mexican Stock Exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d <= 7 && w.equals((Object)Weekday.MONDAY) && m == Month.FEBRUARY || d == 21 && m == Month.MARCH || dd == em - 4 || dd == em - 3 || d == 1 && m == Month.MAY || d == 16 && m == Month.SEPTEMBER || d == 2 && m == Month.NOVEMBER || d >= 14 && d < 21 && w.equals((Object)Weekday.MONDAY) && m == Month.NOVEMBER || d == 12 && m == Month.DECEMBER) && (d != 25 || m != Month.DECEMBER);
        }
    }

    private static final class MexicoSettlementCalendar
    extends WesternCalendar {
        private MexicoSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Mexico stock Market";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d <= 7 && w.equals((Object)Weekday.MONDAY) && m == Month.FEBRUARY || d == 21 && m == Month.MARCH || dd == em - 4 || dd == em - 3 || d == 1 && m == Month.MAY || d == 16 && m == Month.SEPTEMBER || d == 2 && m == Month.NOVEMBER || d >= 14 && d < 21 && w.equals((Object)Weekday.MONDAY) && m == Month.NOVEMBER || d == 12 && m == Month.DECEMBER) && (d != 25 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        SETTLEMENT,
        BMV;

    }
}

