/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.lang.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jquantlib.lang.reflect.TypeNode;

public class TypeTokenTree {
    private final TypeNode root;

    public TypeTokenTree() {
        this.root = this.retrieve(this.getClass());
    }

    public TypeTokenTree(Class<?> klass) {
        this.root = this.retrieve(klass);
    }

    public TypeNode getRoot() {
        return this.root;
    }

    private TypeNode retrieve(Class<?> klass) {
        Type superclass = klass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new IllegalArgumentException("Class should be anonymous or extended from a generic class");
        }
        TypeNode node = new TypeNode(klass);
        for (Type t : ((ParameterizedType)superclass).getActualTypeArguments()) {
            node.add(this.retrieve(t));
        }
        return node;
    }

    private TypeNode retrieve(Type type) {
        TypeNode node;
        if (type instanceof Class) {
            node = new TypeNode((Class)type);
        } else if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            node = this.retrieve(rawType);
            for (Type arg : ((ParameterizedType)type).getActualTypeArguments()) {
                node.add(this.retrieve(arg));
            }
        } else {
            throw new IllegalArgumentException("Illegal type parameter");
        }
        return node;
    }
}

