/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.BilinearInterpolation;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.Interpolator2D;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class BlackVarianceSurface
extends BlackVarianceTermStructure {
    private DayCounter dayCounter;
    private Date maxDate;
    private double[] times;
    private double[] strikes;
    private double[][] variances;
    private Interpolation2D varianceSurface;
    private Extrapolation lowerExtrapolation;
    private Extrapolation upperExtrapolation;
    private Interpolator2D factory;

    public BlackVarianceSurface(Date referenceDate, Date[] dates, double[] strikes, double[][] blackVolMatrix, DayCounter dayCounter) {
        this(referenceDate, dates, strikes, blackVolMatrix, dayCounter, Extrapolation.InterpolatorDefaultExtrapolation, Extrapolation.InterpolatorDefaultExtrapolation);
    }

    public BlackVarianceSurface(Date referenceDate, Date[] dates, double[] strikes, double[][] blackVolMatrix, DayCounter dayCounter, Extrapolation lowerExtrapolation, Extrapolation upperExtrapolation) {
        super(referenceDate);
        this.dayCounter = dayCounter;
        this.maxDate = dates[dates.length];
        this.strikes = (double[])strikes.clone();
        this.lowerExtrapolation = lowerExtrapolation;
        this.upperExtrapolation = upperExtrapolation;
        if (dates.length != blackVolMatrix[0].length) {
            throw new IllegalArgumentException("mismatch between date vector and vol matrix colums");
        }
        if (strikes.length != blackVolMatrix.length) {
            throw new IllegalArgumentException("mismatch between money-strike vector and vol matrix rows");
        }
        if (dates[0].le(referenceDate)) {
            throw new IllegalArgumentException("cannot have dates[0] <= referenceDate");
        }
        this.times = new double[dates.length + 1];
        this.times[0] = 0.0;
        this.variances = new double[strikes.length][dates.length + 1];
        for (int i = 0; i < blackVolMatrix.length; ++i) {
            this.variances[i][0] = 0.0;
        }
        for (int j = 1; j <= blackVolMatrix[0].length; ++j) {
            this.times[j] = this.timeFromReference(dates[j - 1]);
            if (!(this.times[j] > this.times[j - 1])) {
                throw new IllegalArgumentException("dates must be sorted unique!");
            }
            for (int i = 0; i < blackVolMatrix.length; ++i) {
                this.variances[i][j] = this.times[j] * blackVolMatrix[i][j - 1] * blackVolMatrix[i][j - 1];
                if (this.variances[i][j] >= this.variances[i][j - 1]) continue;
                throw new IllegalArgumentException("variance must be non-decreasing");
            }
        }
        this.factory = BilinearInterpolation.getInterpolator();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return this.maxDate;
    }

    @Override
    public final double minStrike() {
        return this.strikes[0];
    }

    @Override
    public final double maxStrike() {
        return this.strikes[this.strikes.length - 1];
    }

    public void setInterpolation(Interpolator i) {
        this.varianceSurface = this.factory.interpolate(this.times, this.strikes, this.variances);
        this.varianceSurface.enableExtrapolation();
        this.varianceSurface.reload();
        this.notifyObservers();
    }

    @Override
    protected final double blackVarianceImpl(double t, double strike) {
        if (t == 0.0) {
            return 0.0;
        }
        if (strike < this.strikes[0] && this.lowerExtrapolation == Extrapolation.ConstantExtrapolation) {
            strike = this.strikes[0];
        }
        if (strike > this.strikes[this.strikes.length - 1] && this.upperExtrapolation == Extrapolation.ConstantExtrapolation) {
            strike = this.strikes[this.strikes.length - 1];
        }
        if (t <= this.times[this.times.length - 1]) {
            return this.varianceSurface.evaluate(t, strike);
        }
        double lastTime = this.times[this.times.length - 1];
        return this.varianceSurface.evaluate(lastTime, strike) * t / lastTime;
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }

    public static enum Extrapolation {
        ConstantExtrapolation,
        InterpolatorDefaultExtrapolation;

    }
}

