/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.taglib.servlet.taglib;

import com.liferay.item.selector.taglib.servlet.ServletContextUtil;
import com.liferay.item.selector.taglib.servlet.item.selector.ItemSelectorUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.taglib.util.IncludeTag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class GroupSelectorTag
extends IncludeTag {
    private static final long[] _CLASSNAME_IDS = new long[]{ClassNameLocalServiceUtil.getClassNameId(Company.class), ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
    private static final Log _log = LogFactoryUtil.getLog(GroupSelectorTag.class);
    private List<Group> _groups;
    private int _groupsCount;

    public void setGroups(List<Group> groups) {
        this._groups = groups;
    }

    public void setGroupsCount(int groupsCount) {
        this._groupsCount = groupsCount;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    protected void cleanUp() {
        super.cleanUp();
        this._groups = null;
        this._groupsCount = 0;
    }

    protected List<Group> getGroups(HttpServletRequest request) {
        if (this._groups != null) {
            return this._groups;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        String keywords = ParamUtil.getString((HttpServletRequest)request, (String)"keywords");
        int cur = ParamUtil.getInteger((HttpServletRequest)request, (String)"cur", (int)1);
        int delta = ParamUtil.getInteger((HttpServletRequest)request, (String)"delta", (int)SearchContainer.DEFAULT_DELTA);
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)cur, (int)delta);
        if (Validator.isNotNull((String)keywords)) {
            LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
            groupParams.put("site", Boolean.TRUE);
            groupParams.put("usersGroups", Long.valueOf(user.getUserId()));
            return GroupLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])_CLASSNAME_IDS, (String)keywords, groupParams, (int)startAndEnd[0], (int)startAndEnd[1], null);
        }
        try {
            List groups = user.getMySiteGroups(null, startAndEnd[1]);
            return ListUtil.subList((List)groups, (int)startAndEnd[0], (int)startAndEnd[1]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return new ArrayList<Group>();
        }
    }

    protected int getGroupsCount(HttpServletRequest request) {
        if (this._groups != null || this._groupsCount > 0) {
            return this._groupsCount;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        String keywords = ParamUtil.getString((HttpServletRequest)request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
            groupParams.put("site", Boolean.TRUE);
            groupParams.put("usersGroups", Long.valueOf(user.getUserId()));
            return GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])_CLASSNAME_IDS, (String)keywords, groupParams);
        }
        try {
            List groups = user.getMySiteGroups(null, -1);
            return groups.size();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    protected String getPage() {
        return "/group_selector/page.jsp";
    }

    protected void setAttributes(HttpServletRequest request) {
        request.setAttribute("liferay-item-selector:group-selector:groups", this.getGroups(request));
        request.setAttribute("liferay-item-selector:group-selector:groupsCount", (Object)this.getGroupsCount(request));
        request.setAttribute("liferay-item-selector:group-selector:itemSelector", (Object)ItemSelectorUtil.getItemSelector());
    }
}

