/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.AbstractDayCounter;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.Month;

public class ActualActual
extends AbstractDayCounter {
    private static final ActualActual ISMA_DAYCOUNTER = new ActualActual(Convention.ISMA);
    private static final ActualActual ACTUAL365_DAYCOUNTER = new ActualActual(Convention.ISDA);
    private static final ActualActual AFB_DAYCOUNTER = new ActualActual(Convention.AFB);
    private final DayCounter delegate;

    public static final ActualActual getDayCounter(Convention convention) {
        switch (convention) {
            case ISMA: 
            case BOND: {
                return ISMA_DAYCOUNTER;
            }
            case ISDA: 
            case HISTORICAL: 
            case ACTUAL365: {
                return ACTUAL365_DAYCOUNTER;
            }
            case AFB: 
            case EURO: {
                return AFB_DAYCOUNTER;
            }
        }
        throw new IllegalArgumentException("unknown act/act convention");
    }

    private ActualActual(Convention convention) {
        switch (convention) {
            case ISMA: 
            case BOND: {
                this.delegate = new ISMA();
                break;
            }
            case ISDA: 
            case HISTORICAL: 
            case ACTUAL365: {
                this.delegate = new ISDA();
                break;
            }
            case AFB: 
            case EURO: {
                this.delegate = new AFB();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown act/act convention");
            }
        }
    }

    @Override
    public final String name() {
        return this.delegate.name();
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd) {
        return this.delegate.yearFraction(dateStart, dateEnd);
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
        return this.delegate.yearFraction(dateStart, dateEnd, refPeriodStart, refPeriodEnd);
    }

    private static final class AFB
    extends AbstractDayCounter {
        private AFB() {
        }

        @Override
        public final String name() {
            return "Actual/Actual (AFB)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd) {
            if (dateStart.equals(dateEnd)) {
                return 0.0;
            }
            if (dateStart.gt(dateEnd)) {
                return -1.0 * this.yearFraction(dateEnd, dateStart, Date.NULL_DATE, Date.NULL_DATE);
            }
            Date newD2 = dateEnd;
            Date temp = dateEnd;
            double sum = 0.0;
            while (temp.gt(dateStart)) {
                temp = newD2.getDateAfter(Period.ONE_YEAR_BACKWARD);
                if (temp.getDayOfMonth() == 28 && temp.getMonth() == 2 && DateFactory.getFactory().isLeap(temp.getYear())) {
                    temp.increment(1);
                }
                if (!temp.ge(dateStart)) continue;
                sum += 1.0;
                newD2 = temp;
            }
            double den = 365.0;
            if (DateFactory.getFactory().isLeap(newD2.getYear())) {
                if (newD2.gt(29, Month.FEBRUARY, newD2.getYear()) && dateStart.le(29, Month.FEBRUARY, newD2.getYear())) {
                    den += 1.0;
                }
            } else if (DateFactory.getFactory().isLeap(dateStart.getYear()) && newD2.gt(29, Month.FEBRUARY, dateStart.getYear()) && dateStart.le(29, Month.FEBRUARY, dateStart.getYear())) {
                den += 1.0;
            }
            return sum + (double)this.dayCount(dateStart, newD2) / den;
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            return this.yearFraction(dateStart, dateEnd);
        }
    }

    private static final class ISDA
    extends AbstractDayCounter {
        private ISDA() {
        }

        @Override
        public final String name() {
            return "Actual/Actual (ISDA)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd) {
            if (dateStart.equals(dateEnd)) {
                return 0.0;
            }
            if (dateStart.gt(dateEnd)) {
                return -this.yearFraction(dateEnd, dateStart, Date.NULL_DATE, Date.NULL_DATE);
            }
            int y1 = dateStart.getYear();
            int y2 = dateEnd.getYear();
            double dib1 = DateFactory.getFactory().isLeap(y1) ? 366.0 : 365.0;
            double dib2 = DateFactory.getFactory().isLeap(y2) ? 366.0 : 365.0;
            double sum = y2 - y1 - 1;
            sum += (dib1 - (double)dateStart.getDayOfYear() + 1.0) / dib1;
            return sum += (double)(dateEnd.getDayOfYear() - 1) / dib2;
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date d3, Date d4) {
            return this.yearFraction(dateStart, dateEnd);
        }
    }

    private static final class ISMA
    extends AbstractDayCounter {
        private ISMA() {
        }

        @Override
        public final String name() {
            return "Actual/Actual (ISMA)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd) {
            return this.yearFraction(dateStart, dateEnd, Date.NULL_DATE, Date.NULL_DATE);
        }

        @Override
        public final double yearFraction(Date d1, Date d2, Date d3, Date d4) {
            Date newRefEnd;
            Date newRefStart;
            Date refPeriodEnd;
            if (d1.equals(d2)) {
                return 0.0;
            }
            if (d1.gt(d2)) {
                return -this.yearFraction(d2, d1, d3, d4);
            }
            Date refPeriodStart = !d3.equals(Date.NULL_DATE) ? d3 : d1;
            Date date = refPeriodEnd = !d4.equals(Date.NULL_DATE) ? d4 : d2;
            if (!refPeriodEnd.gt(refPeriodStart) || !refPeriodEnd.gt(d1)) {
                throw new IllegalArgumentException("invalid reference period: date 1: " + d1 + ", date 2: " + d2 + ", reference period start: " + refPeriodStart + ", reference period end: " + refPeriodEnd);
            }
            int months = (int)(0.5 + (double)(12 * refPeriodStart.getDayCount(refPeriodEnd)) / 365.0);
            if (months == 0) {
                refPeriodStart = d1;
                refPeriodEnd = d1.getDateAfter(Period.ONE_YEAR_FORWARD);
                months = 12;
            }
            double period = (double)months / 12.0;
            if (d2.le(refPeriodEnd)) {
                if (d1.ge(refPeriodStart)) {
                    return period * (double)this.dayCount(d1, d2) / (double)this.dayCount(refPeriodStart, refPeriodEnd);
                }
                Date previousRef = refPeriodStart.getDateAfter(new Period(-months, TimeUnit.MONTHS));
                if (d2.gt(refPeriodStart)) {
                    return this.yearFraction(d1, refPeriodStart, previousRef, refPeriodStart) + this.yearFraction(refPeriodStart, d2, refPeriodStart, refPeriodEnd);
                }
                return this.yearFraction(d1, d2, previousRef, refPeriodStart);
            }
            if (refPeriodStart.gt(d1)) {
                throw new IllegalArgumentException("invalid dates: d1 < refPeriodStart < refPeriodEnd < d2");
            }
            double sum = this.yearFraction(d1, refPeriodEnd, refPeriodStart, refPeriodEnd);
            int i = 0;
            while (true) {
                newRefStart = refPeriodEnd.getDateAfter(new Period(months * i, TimeUnit.MONTHS));
                newRefEnd = refPeriodEnd.getDateAfter(new Period(months * (i + 1), TimeUnit.MONTHS));
                if (d2.lt(newRefEnd)) break;
                sum += period;
                ++i;
            }
            return sum += this.yearFraction(newRefStart, d2, newRefStart, newRefEnd);
        }
    }

    public static enum Convention {
        ISMA,
        BOND,
        ISDA,
        HISTORICAL,
        ACTUAL365,
        AFB,
        EURO;

    }
}

