/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.guid;

import com.infor.core.guid.IGuid;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;

public class CompactGuid
implements IGuid {
    private static final int CONST_256 = 256;
    private static final int STRBUF_SIZE = 10;
    private static final int HEXADDR_BYTES = 4;
    private static final int HEXADDR_LEN = 8;
    private static final int BASE_16 = 16;
    private static final int LOW_NIBBLE = 15;
    private static final int TEN_MILLION = 10000000;
    private static final int TOKENS_PER_GUID = 4;
    protected String group;
    protected long millis;
    protected String hexAddress;
    protected int sequence;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public CompactGuid() {
        this.millis = System.currentTimeMillis();
        this.hexAddress = CompactGuid.inetAddressToHexAddress(null);
        this.validate();
    }

    public CompactGuid(String group, long millis, String hexAddress, int sequence) {
        this.group = group;
        this.millis = millis;
        this.hexAddress = hexAddress;
        this.sequence = sequence;
        this.validate();
    }

    public CompactGuid(String group, int sequence) {
        this();
        this.group = group;
        this.sequence = sequence;
        this.validate();
    }

    public CompactGuid(String guid) {
        if (guid == null) {
            throw new IllegalArgumentException("The guid cannot be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(guid, ":");
        if (tokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("The guid string must contain 4 tokens");
        }
        this.group = tokenizer.nextToken();
        if (this.group.length() == 0) {
            this.group = null;
        }
        try {
            this.millis = Long.parseLong(tokenizer.nextToken());
        }
        catch (NumberFormatException nfx) {
            throw new IllegalArgumentException("The millis token could not be parsed");
        }
        this.hexAddress = tokenizer.nextToken();
        try {
            this.sequence = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfx) {
            throw new IllegalArgumentException("The sequence token could not be parsed");
        }
        this.validate();
    }

    private void validate() {
        if (this.group != null && this.group.indexOf(58) >= 0) {
            throw new IllegalArgumentException("The group cannot contain the ':' character");
        }
    }

    public String getGroup() {
        return this.group;
    }

    public Date getDate() {
        return new Date(this.millis);
    }

    public InetAddress getHostAddress() throws UnknownHostException {
        return CompactGuid.hexAddressToInetAddress(this.hexAddress);
    }

    public int getSequence() {
        return this.sequence;
    }

    public String toString() {
        return (this.group == null ? "" : this.group) + ":" + this.millis + ":" + this.hexAddress + ":" + this.sequence;
    }

    public static String inetAddressToHexAddress(InetAddress addr) {
        byte[] b = null;
        if (addr == null) {
            try {
                b = InetAddress.getLocalHost().getAddress();
            }
            catch (Throwable t) {
                return "R" + new Random().nextInt(10000000);
            }
        } else {
            b = addr.getAddress();
        }
        StringBuffer buf = new StringBuffer(10);
        for (int i = 0; i < b.length; ++i) {
            int ib = b[i];
            if (ib < 0) {
                ib = 256 + ib;
            }
            int i1 = ib / 16;
            int i2 = ib & 0xF;
            buf.append(HEX_CHARS[i1]);
            buf.append(HEX_CHARS[i2]);
        }
        return buf.toString();
    }

    public static InetAddress hexAddressToInetAddress(String hexAddress) throws UnknownHostException {
        int i;
        if (hexAddress == null || hexAddress.length() != 8) {
            throw new IllegalArgumentException("hexAddress must be 8 characters");
        }
        byte[] rawAddress = new byte[4];
        for (i = 0; i < 3; ++i) {
            rawAddress[i] = (byte)Integer.parseInt(hexAddress.substring(i * 2, i * 2 + 2), 16);
        }
        rawAddress[3] = (byte)Integer.parseInt(hexAddress.substring(i * 2), 16);
        return InetAddress.getByAddress(rawAddress);
    }
}

