/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.pool;

import com.infor.core.pool.IRecyclable;
import com.infor.core.pool.IRecycleBin;
import com.infor.core.pool.ThreadPool;

public class ThreadWorker
extends Thread
implements IRecyclable {
    private IRecycleBin recycleBin = null;
    private ThreadPool threadPool = null;
    private Runnable runnable = null;
    private volatile boolean running = true;
    private volatile boolean waiting = false;
    private String id = null;

    public ThreadWorker(IRecycleBin parentPool, ThreadPool group, String id) {
        this(parentPool, group, id, null);
    }

    public ThreadWorker(IRecycleBin recycleBin, ThreadPool group, String id, Runnable runnableObject) {
        super(group, runnableObject, id);
        if (recycleBin == null) {
            throw new NullPointerException("ThreadWorker: recycleBin cannot be null.");
        }
        if (group == null) {
            throw new NullPointerException("ThreadWorker: pool cannot be null.");
        }
        this.recycleBin = recycleBin;
        this.threadPool = group;
        this.runnable = runnableObject;
        this.id = id;
    }

    public void clean() {
    }

    public void destroy() {
        this.running = false;
        if (this.waiting) {
            this.interrupt();
        }
    }

    public synchronized void execute() {
        if (this.runnable != null) {
            this.notify();
        }
    }

    public synchronized void execute(Runnable newRunnable) {
        if (newRunnable != null) {
            this.runnable = newRunnable;
            this.notify();
        }
    }

    public String getID() {
        return this.id;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public final synchronized void run() {
        this.notifyAll();
        while (this.running) {
            try {
                this.waiting = true;
                this.wait();
                this.waiting = false;
            }
            catch (InterruptedException iex) {
                continue;
            }
            if (!this.running || this.runnable == null) continue;
            try {
                this.runnable.run();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable uncaughtException) {
                this.running = false;
            }
            if (!this.running) continue;
            this.recycleBin.recycle(this);
        }
        this.runnable = null;
        this.threadPool.threadDeath();
    }

    public void setRunnable(Runnable newRunnable) {
        this.runnable = newRunnable;
    }
}

