/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.Constants;
import org.jquantlib.math.UnaryFunctionDouble;

public abstract class Integrator {
    private double absoluteAccuracy;
    private double absoluteError;
    private int maxEvaluations;
    private int numberOfEvaluations;

    public Integrator(double absoluteAccuracy, int maxEvaluations) {
        if (absoluteAccuracy <= Constants.QL_EPSILON) {
            throw new IllegalArgumentException("required tolerance(" + absoluteAccuracy + ") must be > " + Constants.QL_EPSILON);
        }
        this.absoluteAccuracy = absoluteAccuracy;
        this.maxEvaluations = maxEvaluations;
    }

    protected abstract double integrate(UnaryFunctionDouble var1, double var2, double var4);

    protected final void setAbsoluteError(double error) {
        this.absoluteError = error;
    }

    protected final void setNumberOfEvaluations(int evaluations) {
        this.numberOfEvaluations = evaluations;
    }

    protected final void increaseNumberOfEvaluations(int increase) {
        this.numberOfEvaluations += increase;
    }

    protected int getNumberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    public double evaluate(UnaryFunctionDouble f, double a, double b) {
        if (a == b) {
            return 0.0;
        }
        if (a > b) {
            return -1.0 * this.evaluate(f, b, a);
        }
        this.numberOfEvaluations = 0;
        return this.integrate(f, a, b);
    }

    public final void setAbsoluteAccuracy(double accuracy) {
        this.absoluteAccuracy = accuracy;
    }

    public final void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public final double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public final int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public final double getAbsoluteError() {
        return this.absoluteError;
    }

    public boolean isIntegrationSuccess() {
        return this.numberOfEvaluations <= this.maxEvaluations && this.absoluteError <= this.absoluteAccuracy;
    }
}

