/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class WebEvent {
    private static final String TOPIC_WEB_EVENT = "org/osgi/service/web";
    public static final String TOPIC_DEPLOYING = "org/osgi/service/web/DEPLOYING";
    public static final String TOPIC_DEPLOYED = "org/osgi/service/web/DEPLOYED";
    public static final String TOPIC_UNDEPLOYING = "org/osgi/service/web/UNDEPLOYING";
    public static final String TOPIC_UNDEPLOYED = "org/osgi/service/web/UNDEPLOYED";
    public static final String TOPIC_FAILED = "org/osgi/service/web/FAILED";
    private static final String CONTEXT_PATH = "context.path";
    private static final String EXCEPTION = "exception";
    private static final String COLLISION = "collision";
    private static final String COLLISION_BUNDLES = "collision.bundles";
    private static final String EXTENDER_BUNDLE = "extender.bundle";
    private static final String EXTENDER_BUNDLE_ID = "extender.bundle.id";
    private static final String EXTENDER_BUNDLE_VERSION = "extender.bundle.version";
    private static final String EXTENDER_BUNDLE_SYMBOLICNAME = "extender.bundle.symbolicName";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";

    private static Dictionary<String, Object> createBaseProperties(Bundle webAppBundle, Bundle extenderBundle) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundle.symbolicName", webAppBundle.getSymbolicName());
        ((Dictionary)props).put("bundle.id", webAppBundle.getBundleId());
        ((Dictionary)props).put("bundle", webAppBundle);
        ((Dictionary)props).put("bundle.version", webAppBundle.getVersion());
        ((Dictionary)props).put(CONTEXT_PATH, webAppBundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH));
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put(EXTENDER_BUNDLE, extenderBundle);
        ((Dictionary)props).put(EXTENDER_BUNDLE_ID, extenderBundle.getBundleId());
        ((Dictionary)props).put(EXTENDER_BUNDLE_SYMBOLICNAME, extenderBundle.getSymbolicName());
        ((Dictionary)props).put(EXTENDER_BUNDLE_VERSION, extenderBundle.getVersion());
        return props;
    }

    public static void postEvent(Object eventAdmin, String topic, Bundle webAppBundle, Bundle extenderBundle, Throwable exception, String collision, Long collisionBundles) {
        Dictionary<String, Object> props = WebEvent.createBaseProperties(webAppBundle, extenderBundle);
        if (exception != null) {
            props.put(EXCEPTION, exception);
        }
        if (collision != null) {
            props.put(COLLISION, collision);
        }
        if (collisionBundles != null) {
            props.put(COLLISION_BUNDLES, collisionBundles);
        }
        Event event = new Event(topic, props);
        ((EventAdmin)eventAdmin).postEvent(event);
    }
}

