/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.util.List;
import org.jquantlib.cashflow.Event;
import org.jquantlib.math.Array;
import org.jquantlib.math.SampledCurve;
import org.jquantlib.methods.finitedifferences.NullCondition;
import org.jquantlib.methods.finitedifferences.StandardFiniteDifferenceModel;
import org.jquantlib.methods.finitedifferences.StepCondition;
import org.jquantlib.pricingengines.arguments.Arguments;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.results.Results;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public abstract class FDMultiPeriodEngine
extends FDVanillaEngine {
    private List<Event> events_;
    private List<Double> stoppingTimes_;
    private int timeStepPerPeriod_;
    protected SampledCurve prices_;
    protected StepCondition<Array> stepCondition_;
    private StandardFiniteDifferenceModel model_;

    public FDMultiPeriodEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        super(process, timeSteps, gridPoints, timeDependent);
    }

    public FDMultiPeriodEngine(GeneralizedBlackScholesProcess process) {
        super(process, 100, 100, false);
    }

    public void setupArguments(Arguments args, List<Event> schedule) {
        super.setupArguments(args);
        this.events_ = schedule;
        this.stoppingTimes_.clear();
        int n = schedule.size();
        for (int i = 0; i < n; ++i) {
            this.stoppingTimes_.add(this.process.getTime(this.events_.get(i).date()));
        }
    }

    @Override
    public void setupArguments(Arguments a) {
        super.setupArguments(a);
        OneAssetOptionArguments args = (OneAssetOptionArguments)a;
        this.events_.clear();
        int n = args.exercise.size();
        for (int i = 0; i < n; ++i) {
            this.stoppingTimes_.add(this.process.getTime(args.exercise.date(i)));
        }
    }

    double getDividendTime(int i) {
        return this.stoppingTimes_.get(i);
    }

    @Override
    public void calculate(Results r) {
        double dt;
        OneAssetOptionResults results = (OneAssetOptionResults)r;
        int dateNumber = this.stoppingTimes_.size();
        boolean lastDateIsResTime = false;
        int firstIndex = -1;
        int lastIndex = dateNumber - 1;
        boolean firstDateIsZero = false;
        double firstNonZeroDate = this.getResidualTime();
        double dateTolerance = 1.0E-6;
        if (dateNumber > 0) {
            if (this.getDividendTime(0) <= 0.0) {
                throw new IllegalArgumentException("first date (" + this.getDividendTime(0) + ") cannot be negative");
            }
            if (this.getDividendTime(0) < this.getResidualTime() * dateTolerance) {
                firstDateIsZero = true;
                firstIndex = 0;
                if (dateNumber >= 2) {
                    firstNonZeroDate = this.getDividendTime(1);
                }
            }
            if (Math.abs(this.getDividendTime(lastIndex) - this.getResidualTime()) < dateTolerance) {
                lastDateIsResTime = true;
                lastIndex = dateNumber - 2;
            }
            if (!firstDateIsZero) {
                firstNonZeroDate = this.getDividendTime(0);
            }
            if (dateNumber >= 2) {
                for (int j = 1; j < dateNumber; ++j) {
                    if (!(this.getDividendTime(j - 1) > this.getDividendTime(j))) continue;
                    throw new IllegalArgumentException("dates must be in increasing order: " + this.getDividendTime(j - 1) + " is not strictly smaller than " + this.getDividendTime(j));
                }
            }
        }
        if (firstNonZeroDate <= (dt = this.getResidualTime() / (double)(this.timeStepPerPeriod_ * (dateNumber + 1)))) {
            dt = firstNonZeroDate / 2.0;
        }
        this.setGridLimits();
        this.initializeInitialCondition();
        this.initializeOperator();
        this.initializeBoundaryConditions();
        this.initializeModel();
        this.initializeStepCondition();
        this.prices_ = this.intrinsicValues;
        if (lastDateIsResTime) {
            this.executeIntermediateStep(dateNumber - 1);
        }
        Integer j = lastIndex;
        do {
            double beginDate = j == dateNumber - 1 ? this.getResidualTime() : this.getDividendTime(j + 1);
            double endDate = j >= 0 ? this.getDividendTime(j) : dt;
            this.prices_.setValues(this.model_.rollback(this.prices_.values(), beginDate, endDate, this.timeStepPerPeriod_, this.stepCondition_));
            if (j < 0) continue;
            this.executeIntermediateStep(j);
        } while ((j = Integer.valueOf(j - 1)) >= firstIndex);
        this.prices_.setValues(this.model_.rollback(this.prices_.values(), dt, 0.0, 1, this.stepCondition_));
        if (firstDateIsZero) {
            this.executeIntermediateStep(0);
        }
        results.value = this.prices_.valueAtCenter();
        results.delta = this.prices_.firstDerivativeAtCenter();
        results.gamma = this.prices_.secondDerivativeAtCenter();
        results.addAdditionalResult("priceCurve", this.prices_);
    }

    protected abstract void executeIntermediateStep(int var1);

    void initializeStepCondition() {
        this.stepCondition_ = new NullCondition<Array>();
    }

    void initializeModel() {
        this.model_ = new StandardFiniteDifferenceModel(this.finiteDifferenceOperator, this.bcS);
    }
}

