/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextAttachment;
import netscape.application.TextParagraph;
import netscape.application.TextView;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class TextStyleRun
implements Codable {
    private static final String CONTENTS_KEY = "contents";
    private static final String ATTRIBUTES_KEY = "attributes";
    TextParagraph _paragraph;
    FastStringBuffer _contents;
    Hashtable _attributes;
    FontMetrics _fontMetricsCache;
    int _remainder;

    public TextStyleRun() {
    }

    TextStyleRun(TextParagraph textParagraph) {
        this();
        this.init(textParagraph);
    }

    TextStyleRun(TextParagraph textParagraph, String string, Hashtable hashtable) {
        this();
        this.init(textParagraph, string, hashtable);
    }

    TextStyleRun(TextParagraph textParagraph, String string, int n, int n2, Hashtable hashtable) {
        this();
        this.init(textParagraph, string, n, n2, hashtable);
    }

    void init(TextParagraph textParagraph) {
        this._paragraph = textParagraph;
    }

    void init(TextParagraph textParagraph, String string, Hashtable hashtable) {
        this.init(textParagraph);
        this.setText(string);
        this.setAttributes(hashtable);
    }

    void init(TextParagraph textParagraph, String string, int n, int n2, Hashtable hashtable) {
        this.init(textParagraph);
        this.setText(string, n, n2);
        this.setAttributes(hashtable);
    }

    TextStyleRun createEmptyRun() {
        return new TextStyleRun(this._paragraph, "", TextView.attributesByRemovingStaticAttributes(this._attributes));
    }

    TextStyleRun createEmptyRun(Hashtable hashtable) {
        return new TextStyleRun(this._paragraph, "", hashtable);
    }

    void setParagraph(TextParagraph textParagraph) {
        this._paragraph = textParagraph;
    }

    TextParagraph paragraph() {
        return this._paragraph;
    }

    void setText(String string) {
        this._contents = new FastStringBuffer(string);
    }

    void setText(String string, int n, int n2) {
        this._contents = new FastStringBuffer(string, n, n2);
    }

    void setText(StringBuffer stringBuffer) {
        this.setText(stringBuffer.toString());
    }

    int rangeIndex() {
        int n = this._paragraph._startChar;
        Vector vector = this._paragraph.runsBefore(this);
        int n2 = 0;
        int n3 = vector.count();
        while (n2 < n3) {
            n += ((TextStyleRun)vector.elementAt(n2)).charCount();
            ++n2;
        }
        return n;
    }

    Range range() {
        return TextView.allocateRange(this.rangeIndex(), this.charCount());
    }

    private Font getFont() {
        Font font = null;
        if (this._paragraph.owner().usesSingleFont()) {
            font = (Font)this._paragraph.owner().defaultAttributes().get("FontKey");
            return font;
        }
        if (this._attributes != null) {
            font = (Font)this._attributes.get("FontKey");
        }
        if (font == null) {
            font = (Font)this._paragraph.owner().defaultAttributes().get("FontKey");
        }
        return font;
    }

    private Color getColor() {
        Color color = null;
        color = this._attributes != null ? (this._attributes.get("LinkKey") != null ? (this._attributes.get("_IFCLinkPressedKey") != null ? (Color)this._attributes.get("PressedLinkColorKey") : (Color)this._attributes.get("LinkColorKey")) : (Color)this._attributes.get("TextColorKey")) : (Color)this._paragraph.owner().defaultAttributes().get("TextColorKey");
        return color;
    }

    private void validateFontMetricsCache() {
        if (this._paragraph.owner().usesSingleFont() || this._attributes == null || this._attributes.get("FontKey") == null) {
            this._fontMetricsCache = this._paragraph.owner().defaultFontMetrics();
            return;
        }
        if (this._fontMetricsCache == null) {
            this._fontMetricsCache = this.getFont().fontMetrics();
        }
    }

    private void invalidateFontMetricsCache() {
        this._fontMetricsCache = null;
    }

    boolean containsATextAttachment() {
        return this._attributes != null && this._attributes.get("TextAttachmentKey") != null;
    }

    Rect textAttachmentBoundsForOrigin(int n, int n2, int n3) {
        TextAttachment textAttachment;
        Rect rect = new Rect();
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            rect.x = n;
            rect.y = n2 + n3 - textAttachment.height() + this.attachmentBaselineOffset();
            rect.width = textAttachment.width();
            rect.height = textAttachment.height();
            return rect;
        }
        return null;
    }

    char charAt(int n) {
        FastStringBuffer fastStringBuffer = this._contents;
        if (fastStringBuffer.length() == 0 || n >= fastStringBuffer.length()) {
            return '\u0000';
        }
        return fastStringBuffer.charAt(n);
    }

    void insertCharAt(char c, int n) {
        if (this._contents == null) {
            FastStringBuffer fastStringBuffer;
            this._contents = fastStringBuffer = new FastStringBuffer(c);
            return;
        }
        FastStringBuffer fastStringBuffer = this._contents;
        fastStringBuffer.insert(c, n);
    }

    void insertStringAt(String string, int n) {
        if (n < 0 || string == null) {
            return;
        }
        if (this._contents == null) {
            FastStringBuffer fastStringBuffer;
            this._contents = fastStringBuffer = new FastStringBuffer(string);
            return;
        }
        FastStringBuffer fastStringBuffer = this._contents;
        fastStringBuffer.insert(string, n);
    }

    void removeCharAt(int n) {
        FastStringBuffer fastStringBuffer = this._contents;
        if (fastStringBuffer.length() == 0 || n >= fastStringBuffer.length()) {
            return;
        }
        fastStringBuffer.removeCharAt(n);
    }

    TextStyleRun breakAt(int n) {
        FastStringBuffer fastStringBuffer = this._contents;
        if (fastStringBuffer.length() == 0 || n >= fastStringBuffer.length()) {
            return this.createEmptyRun(TextView.attributesByRemovingStaticAttributes(this._attributes));
        }
        String string = fastStringBuffer.toString();
        TextStyleRun textStyleRun = new TextStyleRun(this._paragraph, string.substring(n, fastStringBuffer.length()), TextView.attributesByRemovingStaticAttributes(this._attributes));
        fastStringBuffer.truncateToLength(n);
        return textStyleRun;
    }

    void cutBefore(int n) {
        FastStringBuffer fastStringBuffer = this._contents;
        if (fastStringBuffer.length() == 0 || n >= fastStringBuffer.length()) {
            return;
        }
        fastStringBuffer.moveChars(n, 0);
    }

    void cutAfter(int n) {
        FastStringBuffer fastStringBuffer = this._contents;
        if (fastStringBuffer.length() == 0 || n >= fastStringBuffer.length()) {
            return;
        }
        fastStringBuffer.truncateToLength(n);
    }

    String text() {
        return this._contents.toString();
    }

    public String toString() {
        String string = "";
        string = this._attributes != null ? string + this._attributes.toString() : string + "{DefAttr}";
        string = string + "**(";
        string = string + this._contents.toString();
        string = string + ")**";
        return string;
    }

    int charCount() {
        return this._contents.length();
    }

    int attachmentBaselineOffset() {
        Integer n;
        if (this._attributes != null && (n = (Integer)this._attributes.get("TextAttachmentBaselineOffsetKey")) != null) {
            return n;
        }
        return 0;
    }

    int height() {
        TextAttachment textAttachment;
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int n = this.attachmentBaselineOffset();
            if (n > 0) {
                return Math.max(textAttachment.height(), n);
            }
            return textAttachment.height() + Math.abs(n);
        }
        this.validateFontMetricsCache();
        return this._fontMetricsCache.ascent() + this._fontMetricsCache.descent();
    }

    int baseline() {
        TextAttachment textAttachment;
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int n = this.attachmentBaselineOffset();
            return Math.max(textAttachment.height() - n, 0);
        }
        this.validateFontMetricsCache();
        return this._fontMetricsCache.ascent();
    }

    int _widthForTab(int n, int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n < nArray[n2]) {
                return nArray[n2] - n;
            }
            ++n2;
        }
        return 0;
    }

    int _breakForSubstring(int n, int n2, int n3) {
        int n4 = this._widthOfSubstring(n, n2, 0, null);
        while (n4 > n3 && n2 > 0) {
            n4 = this._widthOfSubstring(n, --n2, 0, null);
        }
        return n2;
    }

    int charsForWidth(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        int n6;
        int n7;
        TextAttachment textAttachment;
        int n8 = -1;
        char[] cArray = new char[1];
        if (this._contents == null) {
            this._remainder = n3;
            return 0;
        }
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            if (textAttachment.width() > n4) {
                if (n7 == n4) {
                    this._remainder = 0;
                    return 1;
                }
                return 0;
            }
            if (textAttachment.width() <= n7) {
                this._remainder = n7 - textAttachment.width();
                return 1;
            }
            this._remainder = n7;
            return 0;
        }
        this.validateFontMetricsCache();
        int[] nArray2 = this._fontMetricsCache.widthsArray();
        int n9 = this._contents.length();
        int n10 = n;
        for (n7 = n3; n10 < n9 && n7 > 0; n7 -= n6 + n5) {
            n5 = 0;
            n6 = 0;
            int n11 = n10;
            int n12 = -1;
            while (n10 < n9 && this._contents.buffer[n10] != ' ' && this._contents.buffer[n10] != '\t') {
                if (this._contents.buffer[n10] < '\u0100') {
                    n6 += nArray2[this._contents.buffer[n10]];
                } else {
                    cArray[0] = this._contents.buffer[n10];
                    n6 += this._fontMetricsCache.stringWidth(new String(cArray));
                }
                ++n10;
                if (n6 <= n7 || n12 != -1) continue;
                n12 = n10;
                break;
            }
            if (n10 < n9 && (this._contents.buffer[n10] == ' ' || this._contents.buffer[n10] == '\t')) {
                while (n10 < n9 && (this._contents.buffer[n10] == ' ' || this._contents.buffer[n10] == '\t')) {
                    if (this._contents.buffer[n10] == ' ') {
                        n5 += nArray2[32];
                    } else {
                        n5 += this._widthForTab(n2 + n6 + n5, nArray);
                        if (n8 == -1) {
                            n8 = n10;
                        }
                    }
                    ++n10;
                }
            }
            if (n6 + n5 <= n7) {
                continue;
            }
            if (n7 <= n4 && n6 <= n7) {
                n7 -= n6;
                break;
            }
            if (n6 > n7 && n7 >= n4) {
                n9 = n12 != -1 ? this._breakForSubstring(n11, n12 - n11, n7) : this._breakForSubstring(n11, n10 - n11, n7);
                if (n9 > 0) {
                    n10 = n + n9;
                    n7 -= this._widthOfSubstring(n, n9, 0, null);
                    break;
                }
                n10 = n11;
                break;
            }
            n10 = n11;
            break;
        }
        this._remainder = n7 > 0 ? n7 : 0;
        if (n10 == n && n7 == n4) {
            this._remainder = 0;
            return 1;
        }
        return n10 - n;
    }

    int _widthOfSubstring(int n, int n2, int n3, int[] nArray) {
        int n4 = 0;
        char[] cArray = new char[1];
        this.validateFontMetricsCache();
        int[] nArray2 = this._fontMetricsCache.widthsArray();
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            if (this._contents.buffer[n6] == '\t' && nArray != null) {
                n4 += this._widthForTab(n3 + n4, nArray);
            } else if (this._contents.buffer[n6] < '\u0100') {
                n4 += nArray2[this._contents.buffer[n6]];
            } else {
                cArray[0] = this._contents.buffer[n6];
                n4 += this._fontMetricsCache.stringWidth(new String(cArray));
            }
            ++n6;
        }
        return n4;
    }

    int widthOfContents(int n, int n2, int n3, int[] nArray) {
        TextAttachment textAttachment;
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            return textAttachment.width();
        }
        this.validateFontMetricsCache();
        if (n2 == 0) {
            return 0;
        }
        if (n < 0) {
            n = 0;
        }
        if (n + n2 > this._contents.length()) {
            n2 = this._contents.length() - n;
        }
        return this._widthOfSubstring(n, n2, n3, nArray);
    }

    int drawCharacters(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray) {
        TextAttachment textAttachment;
        if (graphics == null) {
            return 0;
        }
        if (this._attributes != null && (textAttachment = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int n5 = this.attachmentBaselineOffset();
            Rect rect = Rect.newRect(n3, n4 - textAttachment.height() + n5, 0, 0);
            rect.width = textAttachment.width();
            rect.height = textAttachment.height();
            textAttachment.drawInRect(graphics, rect);
            Rect.returnRect(rect);
            return textAttachment.width();
        }
        this.validateFontMetricsCache();
        if (this._fontMetricsCache == null || n2 <= 0) {
            return 0;
        }
        graphics.setFont(this.getFont());
        graphics.setColor(this.getColor());
        if (n < 0) {
            n = 0;
        }
        if (n + n2 > this._contents.length()) {
            n2 = this._contents.length() - n;
        }
        char[] cArray = this._contents.charArray();
        int[] nArray2 = this._fontMetricsCache.widthsArray();
        int n6 = n + n2;
        int n7 = 0;
        while (n < n6) {
            int n8 = this._contents.indexOf('\t', n);
            int n9 = n8 == -1 ? n6 - n : n8 - n;
            if (n9 > 0) {
                graphics.drawChars(cArray, n, n9, n3, n4);
            }
            if (n8 != -1) {
                ++n9;
            }
            int n10 = this._widthOfSubstring(n, n9, n3, nArray);
            n3 += n10;
            n7 += n10;
            n += n9;
        }
        return n7;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.TextStyleRun", 1);
        classInfo.addField(CONTENTS_KEY, (byte)16);
        classInfo.addField(ATTRIBUTES_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString(CONTENTS_KEY, this._contents.toString());
        encoder.encodeObject(ATTRIBUTES_KEY, this._attributes);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._contents = new FastStringBuffer(decoder.decodeString(CONTENTS_KEY));
        this._attributes = (Hashtable)decoder.decodeObject(ATTRIBUTES_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    void setAttributes(Hashtable hashtable) {
        if (hashtable != null) {
            this.invalidateFontMetricsCache();
            this._attributes = (Hashtable)hashtable.clone();
        } else {
            this._attributes = null;
        }
        if (this._attributes != null && this._attributes.get("ParagraphFormatKey") != null) {
            this._attributes.remove("ParagraphFormatKey");
        }
    }

    void appendAttributes(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        if (this._attributes == null) {
            this._attributes = (Hashtable)this._paragraph.owner().defaultAttributes().clone();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("FontKey")) {
                this.invalidateFontMetricsCache();
            }
            this._attributes.put(string, hashtable.get(string));
        }
    }

    Hashtable attributes() {
        if (this._attributes != null) {
            this._attributes.put("ParagraphFormatKey", this._paragraph.currentParagraphFormat());
            return this._attributes;
        }
        return null;
    }
}

