package aQute.maven.repo.provider;

import java.io.File;

import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.MetadataParser.RevisionMetadata;
import aQute.maven.repo.provider.MetadataParser.SnapshotVersion;

public class SnapshotReleaser extends Releaser {

	private MavenVersion	snapshotVersion;
	private long			timestamp	= System.currentTimeMillis();
	private String			build		= null;

	public SnapshotReleaser(MavenStorage home, Revision revision) throws Exception {
		super(home, revision);
		force();
		assert revision.isSnapshot();
		setBuild(timestamp, build);
	}

	@Override
	public void setBuild(long timestamp, String build) {
		this.timestamp = timestamp;
		this.build = build;
		snapshotVersion = revision.version.toSnapshot(timestamp, build);
	}

	public void updateMetadata() throws Exception {
		final RevisionMetadata revisionMetadata;
		revisionMetadata = localOnly ? new RevisionMetadata() : home.snapshot.getMetadata(revision);
		revisionMetadata.group = revision.group;
		revisionMetadata.artifact = revision.artifact;
		revisionMetadata.lastUpdated = programMetadata.lastUpdated;

		for (Archive archive : upload) {
			SnapshotVersion snapshotVersion = new SnapshotVersion();
			snapshotVersion.extension = archive.extension;
			snapshotVersion.classifier = archive.classifier.isEmpty() ? null : archive.classifier;
			snapshotVersion.updated = programMetadata.lastUpdated;
			snapshotVersion.value = this.snapshotVersion;
			revisionMetadata.snapshotVersions.add(snapshotVersion);
		}

		File metafile = home.toLocalFile(revision.metadata(home.id));
		metafile.getParentFile().mkdirs();
		IO.store(revisionMetadata.toString(), metafile);
		home.release.store(metafile, revision.metadata());

		super.updateMetadata();
	}

	protected Archive resolve(Archive archive) throws Exception {
		Archive resolved = archive.resolveSnapshot(snapshotVersion);
		return resolved;
	}

}
