package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRegionIsps invokes the ens.DescribeRegionIsps API synchronously
func (client *Client) DescribeRegionIsps(request *DescribeRegionIspsRequest) (response *DescribeRegionIspsResponse, err error) {
	response = CreateDescribeRegionIspsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRegionIspsWithChan invokes the ens.DescribeRegionIsps API asynchronously
func (client *Client) DescribeRegionIspsWithChan(request *DescribeRegionIspsRequest) (<-chan *DescribeRegionIspsResponse, <-chan error) {
	responseChan := make(chan *DescribeRegionIspsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRegionIsps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRegionIspsWithCallback invokes the ens.DescribeRegionIsps API asynchronously
func (client *Client) DescribeRegionIspsWithCallback(request *DescribeRegionIspsRequest, callback func(response *DescribeRegionIspsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRegionIspsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRegionIsps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRegionIspsRequest is the request struct for api DescribeRegionIsps
type DescribeRegionIspsRequest struct {
	*requests.RpcRequest
	EnsRegionId string `position:"Query" name:"EnsRegionId"`
}

// DescribeRegionIspsResponse is the response struct for api DescribeRegionIsps
type DescribeRegionIspsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Isps      []Isp  `json:"Isps" xml:"Isps"`
}

// CreateDescribeRegionIspsRequest creates a request to invoke DescribeRegionIsps API
func CreateDescribeRegionIspsRequest() (request *DescribeRegionIspsRequest) {
	request = &DescribeRegionIspsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeRegionIsps", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeRegionIspsResponse creates a response to parse from DescribeRegionIsps response
func CreateDescribeRegionIspsResponse() (response *DescribeRegionIspsResponse) {
	response = &DescribeRegionIspsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
