package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUidWhiteListGroup invokes the jarvis.CreateUidWhiteListGroup API synchronously
// api document: https://help.aliyun.com/api/jarvis/createuidwhitelistgroup.html
func (client *Client) CreateUidWhiteListGroup(request *CreateUidWhiteListGroupRequest) (response *CreateUidWhiteListGroupResponse, err error) {
	response = CreateCreateUidWhiteListGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUidWhiteListGroupWithChan invokes the jarvis.CreateUidWhiteListGroup API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createuidwhitelistgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUidWhiteListGroupWithChan(request *CreateUidWhiteListGroupRequest) (<-chan *CreateUidWhiteListGroupResponse, <-chan error) {
	responseChan := make(chan *CreateUidWhiteListGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUidWhiteListGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUidWhiteListGroupWithCallback invokes the jarvis.CreateUidWhiteListGroup API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createuidwhitelistgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUidWhiteListGroupWithCallback(request *CreateUidWhiteListGroupRequest, callback func(response *CreateUidWhiteListGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUidWhiteListGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateUidWhiteListGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUidWhiteListGroupRequest is the request struct for api CreateUidWhiteListGroup
type CreateUidWhiteListGroupRequest struct {
	*requests.RpcRequest
	Note            string           `position:"Query" name:"Note"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	DstPort         requests.Integer `position:"Query" name:"DstPort"`
	InstanceIdList  string           `position:"Query" name:"InstanceIdList"`
	LiveTime        requests.Integer `position:"Query" name:"LiveTime"`
	ProductName     string           `position:"Query" name:"ProductName"`
	WhiteListType   requests.Integer `position:"Query" name:"WhiteListType"`
	Lang            string           `position:"Query" name:"Lang"`
	SrcUid          string           `position:"Query" name:"SrcUid"`
	SourceCode      string           `position:"Query" name:"SourceCode"`
}

// CreateUidWhiteListGroupResponse is the response struct for api CreateUidWhiteListGroup
type CreateUidWhiteListGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
}

// CreateCreateUidWhiteListGroupRequest creates a request to invoke CreateUidWhiteListGroup API
func CreateCreateUidWhiteListGroupRequest() (request *CreateUidWhiteListGroupRequest) {
	request = &CreateUidWhiteListGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "CreateUidWhiteListGroup", "jarvis", "openAPI")
	return
}

// CreateCreateUidWhiteListGroupResponse creates a response to parse from CreateUidWhiteListGroup response
func CreateCreateUidWhiteListGroupResponse() (response *CreateUidWhiteListGroupResponse) {
	response = &CreateUidWhiteListGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
