package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainTimeShiftData invokes the live.DescribeLiveDomainTimeShiftData API synchronously
func (client *Client) DescribeLiveDomainTimeShiftData(request *DescribeLiveDomainTimeShiftDataRequest) (response *DescribeLiveDomainTimeShiftDataResponse, err error) {
	response = CreateDescribeLiveDomainTimeShiftDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainTimeShiftDataWithChan invokes the live.DescribeLiveDomainTimeShiftData API asynchronously
func (client *Client) DescribeLiveDomainTimeShiftDataWithChan(request *DescribeLiveDomainTimeShiftDataRequest) (<-chan *DescribeLiveDomainTimeShiftDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainTimeShiftDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainTimeShiftData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainTimeShiftDataWithCallback invokes the live.DescribeLiveDomainTimeShiftData API asynchronously
func (client *Client) DescribeLiveDomainTimeShiftDataWithCallback(request *DescribeLiveDomainTimeShiftDataRequest, callback func(response *DescribeLiveDomainTimeShiftDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainTimeShiftDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainTimeShiftData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainTimeShiftDataRequest is the request struct for api DescribeLiveDomainTimeShiftData
type DescribeLiveDomainTimeShiftDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeLiveDomainTimeShiftDataResponse is the response struct for api DescribeLiveDomainTimeShiftData
type DescribeLiveDomainTimeShiftDataResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TimeShiftData TimeShiftData `json:"TimeShiftData" xml:"TimeShiftData"`
}

// CreateDescribeLiveDomainTimeShiftDataRequest creates a request to invoke DescribeLiveDomainTimeShiftData API
func CreateDescribeLiveDomainTimeShiftDataRequest() (request *DescribeLiveDomainTimeShiftDataRequest) {
	request = &DescribeLiveDomainTimeShiftDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainTimeShiftData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainTimeShiftDataResponse creates a response to parse from DescribeLiveDomainTimeShiftData response
func CreateDescribeLiveDomainTimeShiftDataResponse() (response *DescribeLiveDomainTimeShiftDataResponse) {
	response = &DescribeLiveDomainTimeShiftDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
