package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVmAppMeshInfo invokes the servicemesh.GetVmAppMeshInfo API synchronously
func (client *Client) GetVmAppMeshInfo(request *GetVmAppMeshInfoRequest) (response *GetVmAppMeshInfoResponse, err error) {
	response = CreateGetVmAppMeshInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetVmAppMeshInfoWithChan invokes the servicemesh.GetVmAppMeshInfo API asynchronously
func (client *Client) GetVmAppMeshInfoWithChan(request *GetVmAppMeshInfoRequest) (<-chan *GetVmAppMeshInfoResponse, <-chan error) {
	responseChan := make(chan *GetVmAppMeshInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVmAppMeshInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVmAppMeshInfoWithCallback invokes the servicemesh.GetVmAppMeshInfo API asynchronously
func (client *Client) GetVmAppMeshInfoWithCallback(request *GetVmAppMeshInfoRequest, callback func(response *GetVmAppMeshInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVmAppMeshInfoResponse
		var err error
		defer close(result)
		response, err = client.GetVmAppMeshInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVmAppMeshInfoRequest is the request struct for api GetVmAppMeshInfo
type GetVmAppMeshInfoRequest struct {
	*requests.RpcRequest
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
}

// GetVmAppMeshInfoResponse is the response struct for api GetVmAppMeshInfo
type GetVmAppMeshInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetVmAppMeshInfoRequest creates a request to invoke GetVmAppMeshInfo API
func CreateGetVmAppMeshInfoRequest() (request *GetVmAppMeshInfoRequest) {
	request = &GetVmAppMeshInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "GetVmAppMeshInfo", "servicemesh", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetVmAppMeshInfoResponse creates a response to parse from GetVmAppMeshInfo response
func CreateGetVmAppMeshInfoResponse() (response *GetVmAppMeshInfoResponse) {
	response = &GetVmAppMeshInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
