package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSubscriptionItems invokes the subscription.ListSubscriptionItems API synchronously
// api document: https://help.aliyun.com/api/subscription/listsubscriptionitems.html
func (client *Client) ListSubscriptionItems(request *ListSubscriptionItemsRequest) (response *ListSubscriptionItemsResponse, err error) {
	response = CreateListSubscriptionItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSubscriptionItemsWithChan invokes the subscription.ListSubscriptionItems API asynchronously
// api document: https://help.aliyun.com/api/subscription/listsubscriptionitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSubscriptionItemsWithChan(request *ListSubscriptionItemsRequest) (<-chan *ListSubscriptionItemsResponse, <-chan error) {
	responseChan := make(chan *ListSubscriptionItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSubscriptionItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSubscriptionItemsWithCallback invokes the subscription.ListSubscriptionItems API asynchronously
// api document: https://help.aliyun.com/api/subscription/listsubscriptionitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSubscriptionItemsWithCallback(request *ListSubscriptionItemsRequest, callback func(response *ListSubscriptionItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSubscriptionItemsResponse
		var err error
		defer close(result)
		response, err = client.ListSubscriptionItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSubscriptionItemsRequest is the request struct for api ListSubscriptionItems
type ListSubscriptionItemsRequest struct {
	*requests.RpcRequest
	Locale     string           `position:"Query" name:"Locale"`
	Filter     string           `position:"Query" name:"Filter"`
	ItemId     requests.Integer `position:"Query" name:"ItemId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListSubscriptionItemsResponse is the response struct for api ListSubscriptionItems
type ListSubscriptionItemsResponse struct {
	*responses.BaseResponse
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	Message           string             `json:"Message" xml:"Message"`
	NextToken         int                `json:"NextToken" xml:"NextToken"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	Code              string             `json:"Code" xml:"Code"`
	Success           bool               `json:"Success" xml:"Success"`
	SubscriptionItems []SubscriptionItem `json:"SubscriptionItems" xml:"SubscriptionItems"`
}

// CreateListSubscriptionItemsRequest creates a request to invoke ListSubscriptionItems API
func CreateListSubscriptionItemsRequest() (request *ListSubscriptionItemsRequest) {
	request = &ListSubscriptionItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "ListSubscriptionItems", "", "")
	return
}

// CreateListSubscriptionItemsResponse creates a response to parse from ListSubscriptionItems response
func CreateListSubscriptionItemsResponse() (response *ListSubscriptionItemsResponse) {
	response = &ListSubscriptionItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
