package yundun_dbaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClearInstanceStorage invokes the yundun_dbaudit.ClearInstanceStorage API synchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/clearinstancestorage.html
func (client *Client) ClearInstanceStorage(request *ClearInstanceStorageRequest) (response *ClearInstanceStorageResponse, err error) {
	response = CreateClearInstanceStorageResponse()
	err = client.DoAction(request, response)
	return
}

// ClearInstanceStorageWithChan invokes the yundun_dbaudit.ClearInstanceStorage API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/clearinstancestorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ClearInstanceStorageWithChan(request *ClearInstanceStorageRequest) (<-chan *ClearInstanceStorageResponse, <-chan error) {
	responseChan := make(chan *ClearInstanceStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClearInstanceStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClearInstanceStorageWithCallback invokes the yundun_dbaudit.ClearInstanceStorage API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/clearinstancestorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ClearInstanceStorageWithCallback(request *ClearInstanceStorageRequest, callback func(response *ClearInstanceStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClearInstanceStorageResponse
		var err error
		defer close(result)
		response, err = client.ClearInstanceStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClearInstanceStorageRequest is the request struct for api ClearInstanceStorage
type ClearInstanceStorageRequest struct {
	*requests.RpcRequest
	StorageCategory string `position:"Query" name:"StorageCategory"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Lang            string `position:"Query" name:"Lang"`
	StorageSpace    string `position:"Query" name:"StorageSpace"`
}

// ClearInstanceStorageResponse is the response struct for api ClearInstanceStorage
type ClearInstanceStorageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateClearInstanceStorageRequest creates a request to invoke ClearInstanceStorage API
func CreateClearInstanceStorageRequest() (request *ClearInstanceStorageRequest) {
	request = &ClearInstanceStorageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-dbaudit", "2018-10-29", "ClearInstanceStorage", "dbaudit", "openAPI")
	return
}

// CreateClearInstanceStorageResponse creates a response to parse from ClearInstanceStorage response
func CreateClearInstanceStorageResponse() (response *ClearInstanceStorageResponse) {
	response = &ClearInstanceStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
