// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package artifact

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSettingsRequest method.
//	req, resp := client.GetAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetAccountSettings
func (c *Artifact) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/account-settings/get",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Artifact.
//
// Get the account settings for Artifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Request to create/modify content would result in a conflict.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetAccountSettings
func (c *Artifact) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReport = "GetReport"

// GetReportRequest generates a "aws/request.Request" representing the
// client's request for the GetReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReport for more information on using the GetReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReportRequest method.
//	req, resp := client.GetReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReport
func (c *Artifact) GetReportRequest(input *GetReportInput) (req *request.Request, output *GetReportOutput) {
	op := &request.Operation{
		Name:       opGetReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/report/get",
	}

	if input == nil {
		input = &GetReportInput{}
	}

	output = &GetReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReport API operation for AWS Artifact.
//
// Get the content for a single report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation GetReport for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Request to create/modify content would result in a conflict.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReport
func (c *Artifact) GetReport(input *GetReportInput) (*GetReportOutput, error) {
	req, out := c.GetReportRequest(input)
	return out, req.Send()
}

// GetReportWithContext is the same as GetReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) GetReportWithContext(ctx aws.Context, input *GetReportInput, opts ...request.Option) (*GetReportOutput, error) {
	req, out := c.GetReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReportMetadata = "GetReportMetadata"

// GetReportMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetReportMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReportMetadata for more information on using the GetReportMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetReportMetadataRequest method.
//	req, resp := client.GetReportMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReportMetadata
func (c *Artifact) GetReportMetadataRequest(input *GetReportMetadataInput) (req *request.Request, output *GetReportMetadataOutput) {
	op := &request.Operation{
		Name:       opGetReportMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/report/getMetadata",
	}

	if input == nil {
		input = &GetReportMetadataInput{}
	}

	output = &GetReportMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReportMetadata API operation for AWS Artifact.
//
// Get the metadata for a single report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation GetReportMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetReportMetadata
func (c *Artifact) GetReportMetadata(input *GetReportMetadataInput) (*GetReportMetadataOutput, error) {
	req, out := c.GetReportMetadataRequest(input)
	return out, req.Send()
}

// GetReportMetadataWithContext is the same as GetReportMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetReportMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) GetReportMetadataWithContext(ctx aws.Context, input *GetReportMetadataInput, opts ...request.Option) (*GetReportMetadataOutput, error) {
	req, out := c.GetReportMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTermForReport = "GetTermForReport"

// GetTermForReportRequest generates a "aws/request.Request" representing the
// client's request for the GetTermForReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTermForReport for more information on using the GetTermForReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTermForReportRequest method.
//	req, resp := client.GetTermForReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetTermForReport
func (c *Artifact) GetTermForReportRequest(input *GetTermForReportInput) (req *request.Request, output *GetTermForReportOutput) {
	op := &request.Operation{
		Name:       opGetTermForReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/report/getTermForReport",
	}

	if input == nil {
		input = &GetTermForReportInput{}
	}

	output = &GetTermForReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTermForReport API operation for AWS Artifact.
//
// Get the Term content associated with a single report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation GetTermForReport for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Request to create/modify content would result in a conflict.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/GetTermForReport
func (c *Artifact) GetTermForReport(input *GetTermForReportInput) (*GetTermForReportOutput, error) {
	req, out := c.GetTermForReportRequest(input)
	return out, req.Send()
}

// GetTermForReportWithContext is the same as GetTermForReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetTermForReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) GetTermForReportWithContext(ctx aws.Context, input *GetTermForReportInput, opts ...request.Option) (*GetTermForReportOutput, error) {
	req, out := c.GetTermForReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReports = "ListReports"

// ListReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReports for more information on using the ListReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReportsRequest method.
//	req, resp := client.ListReportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports
func (c *Artifact) ListReportsRequest(input *ListReportsInput) (req *request.Request, output *ListReportsOutput) {
	op := &request.Operation{
		Name:       opListReports,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/report/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReportsInput{}
	}

	output = &ListReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReports API operation for AWS Artifact.
//
// List available reports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation ListReports for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/ListReports
func (c *Artifact) ListReports(input *ListReportsInput) (*ListReportsOutput, error) {
	req, out := c.ListReportsRequest(input)
	return out, req.Send()
}

// ListReportsWithContext is the same as ListReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) ListReportsWithContext(ctx aws.Context, input *ListReportsInput, opts ...request.Option) (*ListReportsOutput, error) {
	req, out := c.ListReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReportsPages iterates over the pages of a ListReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReports operation.
//	pageNum := 0
//	err := client.ListReportsPages(params,
//	    func(page *artifact.ListReportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Artifact) ListReportsPages(input *ListReportsInput, fn func(*ListReportsOutput, bool) bool) error {
	return c.ListReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReportsPagesWithContext same as ListReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) ListReportsPagesWithContext(ctx aws.Context, input *ListReportsInput, fn func(*ListReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAccountSettings = "PutAccountSettings"

// PutAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSettings for more information on using the PutAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccountSettingsRequest method.
//	req, resp := client.PutAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/PutAccountSettings
func (c *Artifact) PutAccountSettingsRequest(input *PutAccountSettingsInput) (req *request.Request, output *PutAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opPutAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/account-settings/put",
	}

	if input == nil {
		input = &PutAccountSettingsInput{}
	}

	output = &PutAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAccountSettings API operation for AWS Artifact.
//
// Put the account settings for Artifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Artifact's
// API operation PutAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ConflictException
//     Request to create/modify content would result in a conflict.
//
//   - InternalServerException
//     An unknown server exception has occurred.
//
//   - ValidationException
//     Request fails to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/artifact-2018-05-10/PutAccountSettings
func (c *Artifact) PutAccountSettings(input *PutAccountSettingsInput) (*PutAccountSettingsOutput, error) {
	req, out := c.PutAccountSettingsRequest(input)
	return out, req.Send()
}

// PutAccountSettingsWithContext is the same as PutAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Artifact) PutAccountSettingsWithContext(ctx aws.Context, input *PutAccountSettingsInput, opts ...request.Option) (*PutAccountSettingsOutput, error) {
	req, out := c.PutAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Account settings for the customer.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// Notification subscription status of the customer.
	NotificationSubscriptionStatus *string `locationName:"notificationSubscriptionStatus" type:"string" enum:"NotificationSubscriptionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetNotificationSubscriptionStatus sets the NotificationSubscriptionStatus field's value.
func (s *AccountSettings) SetNotificationSubscriptionStatus(v string) *AccountSettings {
	s.NotificationSubscriptionStatus = &v
	return s
}

// Request to create/modify content would result in a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the affected resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the affected resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Account settings for the customer.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

type GetReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique resource ID for the report resource.
	//
	// ReportId is a required field
	ReportId *string `location:"querystring" locationName:"reportId" type:"string" required:"true"`

	// Version for the report resource.
	ReportVersion *int64 `location:"querystring" locationName:"reportVersion" min:"1" type:"long"`

	// Unique download token provided by GetTermForReport API.
	//
	// TermToken is a required field
	TermToken *string `location:"querystring" locationName:"termToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportVersion != nil && *s.ReportVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReportVersion", 1))
	}
	if s.TermToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TermToken"))
	}
	if s.TermToken != nil && len(*s.TermToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TermToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetReportInput) SetReportId(v string) *GetReportInput {
	s.ReportId = &v
	return s
}

// SetReportVersion sets the ReportVersion field's value.
func (s *GetReportInput) SetReportVersion(v int64) *GetReportInput {
	s.ReportVersion = &v
	return s
}

// SetTermToken sets the TermToken field's value.
func (s *GetReportInput) SetTermToken(v string) *GetReportInput {
	s.TermToken = &v
	return s
}

type GetReportMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique resource ID for the report resource.
	//
	// ReportId is a required field
	ReportId *string `location:"querystring" locationName:"reportId" type:"string" required:"true"`

	// Version for the report resource.
	ReportVersion *int64 `location:"querystring" locationName:"reportVersion" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReportMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReportMetadataInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportVersion != nil && *s.ReportVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReportVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetReportMetadataInput) SetReportId(v string) *GetReportMetadataInput {
	s.ReportId = &v
	return s
}

// SetReportVersion sets the ReportVersion field's value.
func (s *GetReportMetadataInput) SetReportVersion(v int64) *GetReportMetadataInput {
	s.ReportVersion = &v
	return s
}

type GetReportMetadataOutput struct {
	_ struct{} `type:"structure"`

	// Report resource detail.
	ReportDetails *ReportDetail `locationName:"reportDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportMetadataOutput) GoString() string {
	return s.String()
}

// SetReportDetails sets the ReportDetails field's value.
func (s *GetReportMetadataOutput) SetReportDetails(v *ReportDetail) *GetReportMetadataOutput {
	s.ReportDetails = v
	return s
}

type GetReportOutput struct {
	_ struct{} `type:"structure"`

	// Presigned S3 url to access the report content.
	DocumentPresignedUrl *string `locationName:"documentPresignedUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReportOutput) GoString() string {
	return s.String()
}

// SetDocumentPresignedUrl sets the DocumentPresignedUrl field's value.
func (s *GetReportOutput) SetDocumentPresignedUrl(v string) *GetReportOutput {
	s.DocumentPresignedUrl = &v
	return s
}

type GetTermForReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique resource ID for the report resource.
	//
	// ReportId is a required field
	ReportId *string `location:"querystring" locationName:"reportId" type:"string" required:"true"`

	// Version for the report resource.
	ReportVersion *int64 `location:"querystring" locationName:"reportVersion" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTermForReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTermForReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTermForReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTermForReportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportVersion != nil && *s.ReportVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReportVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetTermForReportInput) SetReportId(v string) *GetTermForReportInput {
	s.ReportId = &v
	return s
}

// SetReportVersion sets the ReportVersion field's value.
func (s *GetTermForReportInput) SetReportVersion(v int64) *GetTermForReportInput {
	s.ReportVersion = &v
	return s
}

type GetTermForReportOutput struct {
	_ struct{} `type:"structure"`

	// Presigned S3 url to access the term content.
	DocumentPresignedUrl *string `locationName:"documentPresignedUrl" min:"1" type:"string"`

	// Unique token representing this request event.
	TermToken *string `locationName:"termToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTermForReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTermForReportOutput) GoString() string {
	return s.String()
}

// SetDocumentPresignedUrl sets the DocumentPresignedUrl field's value.
func (s *GetTermForReportOutput) SetDocumentPresignedUrl(v string) *GetTermForReportOutput {
	s.DocumentPresignedUrl = &v
	return s
}

// SetTermToken sets the TermToken field's value.
func (s *GetTermForReportOutput) SetTermToken(v string) *GetTermForReportOutput {
	s.TermToken = &v
	return s
}

// An unknown server exception has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Number of seconds in which the caller can retry the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListReportsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of resources to return in the paginated response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token to request the next page of resources.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReportsInput) SetMaxResults(v int64) *ListReportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportsInput) SetNextToken(v string) *ListReportsInput {
	s.NextToken = &v
	return s
}

type ListReportsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to request the next page of resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of report resources.
	Reports []*ReportSummary `locationName:"reports" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportsOutput) SetNextToken(v string) *ListReportsOutput {
	s.NextToken = &v
	return s
}

// SetReports sets the Reports field's value.
func (s *ListReportsOutput) SetReports(v []*ReportSummary) *ListReportsOutput {
	s.Reports = v
	return s
}

type PutAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// Desired notification subscription status.
	NotificationSubscriptionStatus *string `locationName:"notificationSubscriptionStatus" type:"string" enum:"NotificationSubscriptionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingsInput) GoString() string {
	return s.String()
}

// SetNotificationSubscriptionStatus sets the NotificationSubscriptionStatus field's value.
func (s *PutAccountSettingsInput) SetNotificationSubscriptionStatus(v string) *PutAccountSettingsInput {
	s.NotificationSubscriptionStatus = &v
	return s
}

type PutAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Account settings for the customer.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *PutAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *PutAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

// Full detail for report resource metadata.
type ReportDetail struct {
	_ struct{} `type:"structure"`

	// Acceptance type for report.
	AcceptanceType *string `locationName:"acceptanceType" type:"string" enum:"AcceptanceType"`

	// ARN for the report resource.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Category for the report resource.
	Category *string `locationName:"category" min:"1" type:"string"`

	// Associated company name for the report resource.
	CompanyName *string `locationName:"companyName" min:"1" type:"string"`

	// Timestamp indicating when the report resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// Timestamp indicating when the report resource was deleted.
	DeletedAt *time.Time `locationName:"deletedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Description for the report resource.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Unique resource ID for the report resource.
	Id *string `locationName:"id" type:"string"`

	// Timestamp indicating when the report resource was last modified.
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Name for the report resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Timestamp indicating the report resource effective end.
	PeriodEnd *time.Time `locationName:"periodEnd" type:"timestamp" timestampFormat:"iso8601"`

	// Timestamp indicating the report resource effective start.
	PeriodStart *time.Time `locationName:"periodStart" type:"timestamp" timestampFormat:"iso8601"`

	// Associated product name for the report resource.
	ProductName *string `locationName:"productName" min:"1" type:"string"`

	// Sequence number to enforce optimistic locking.
	SequenceNumber *int64 `locationName:"sequenceNumber" min:"1" type:"long"`

	// Series for the report resource.
	Series *string `locationName:"series" min:"1" type:"string"`

	// Current state of the report resource
	State *string `locationName:"state" type:"string" enum:"PublishedState"`

	// The message associated with the current upload state.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Unique resource ARN for term resource.
	TermArn *string `locationName:"termArn" min:"1" type:"string"`

	// The current state of the document upload.
	UploadState *string `locationName:"uploadState" type:"string" enum:"UploadState"`

	// Version for the report resource.
	Version *int64 `locationName:"version" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDetail) GoString() string {
	return s.String()
}

// SetAcceptanceType sets the AcceptanceType field's value.
func (s *ReportDetail) SetAcceptanceType(v string) *ReportDetail {
	s.AcceptanceType = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ReportDetail) SetArn(v string) *ReportDetail {
	s.Arn = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *ReportDetail) SetCategory(v string) *ReportDetail {
	s.Category = &v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *ReportDetail) SetCompanyName(v string) *ReportDetail {
	s.CompanyName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ReportDetail) SetCreatedAt(v time.Time) *ReportDetail {
	s.CreatedAt = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *ReportDetail) SetDeletedAt(v time.Time) *ReportDetail {
	s.DeletedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReportDetail) SetDescription(v string) *ReportDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReportDetail) SetId(v string) *ReportDetail {
	s.Id = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ReportDetail) SetLastModifiedAt(v time.Time) *ReportDetail {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReportDetail) SetName(v string) *ReportDetail {
	s.Name = &v
	return s
}

// SetPeriodEnd sets the PeriodEnd field's value.
func (s *ReportDetail) SetPeriodEnd(v time.Time) *ReportDetail {
	s.PeriodEnd = &v
	return s
}

// SetPeriodStart sets the PeriodStart field's value.
func (s *ReportDetail) SetPeriodStart(v time.Time) *ReportDetail {
	s.PeriodStart = &v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *ReportDetail) SetProductName(v string) *ReportDetail {
	s.ProductName = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *ReportDetail) SetSequenceNumber(v int64) *ReportDetail {
	s.SequenceNumber = &v
	return s
}

// SetSeries sets the Series field's value.
func (s *ReportDetail) SetSeries(v string) *ReportDetail {
	s.Series = &v
	return s
}

// SetState sets the State field's value.
func (s *ReportDetail) SetState(v string) *ReportDetail {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReportDetail) SetStatusMessage(v string) *ReportDetail {
	s.StatusMessage = &v
	return s
}

// SetTermArn sets the TermArn field's value.
func (s *ReportDetail) SetTermArn(v string) *ReportDetail {
	s.TermArn = &v
	return s
}

// SetUploadState sets the UploadState field's value.
func (s *ReportDetail) SetUploadState(v string) *ReportDetail {
	s.UploadState = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ReportDetail) SetVersion(v int64) *ReportDetail {
	s.Version = &v
	return s
}

// Summary for report resource.
type ReportSummary struct {
	_ struct{} `type:"structure"`

	// ARN for the report resource.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Category for the report resource.
	Category *string `locationName:"category" min:"1" type:"string"`

	// Associated company name for the report resource.
	CompanyName *string `locationName:"companyName" min:"1" type:"string"`

	// Description for the report resource.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Unique resource ID for the report resource.
	Id *string `locationName:"id" type:"string"`

	// Name for the report resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Timestamp indicating the report resource effective end.
	PeriodEnd *time.Time `locationName:"periodEnd" type:"timestamp" timestampFormat:"iso8601"`

	// Timestamp indicating the report resource effective start.
	PeriodStart *time.Time `locationName:"periodStart" type:"timestamp" timestampFormat:"iso8601"`

	// Associated product name for the report resource.
	ProductName *string `locationName:"productName" min:"1" type:"string"`

	// Series for the report resource.
	Series *string `locationName:"series" min:"1" type:"string"`

	// Current state of the report resource.
	State *string `locationName:"state" type:"string" enum:"PublishedState"`

	// The message associated with the current upload state.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The current state of the document upload.
	UploadState *string `locationName:"uploadState" type:"string" enum:"UploadState"`

	// Version for the report resource.
	Version *int64 `locationName:"version" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReportSummary) SetArn(v string) *ReportSummary {
	s.Arn = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *ReportSummary) SetCategory(v string) *ReportSummary {
	s.Category = &v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *ReportSummary) SetCompanyName(v string) *ReportSummary {
	s.CompanyName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReportSummary) SetDescription(v string) *ReportSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReportSummary) SetId(v string) *ReportSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReportSummary) SetName(v string) *ReportSummary {
	s.Name = &v
	return s
}

// SetPeriodEnd sets the PeriodEnd field's value.
func (s *ReportSummary) SetPeriodEnd(v time.Time) *ReportSummary {
	s.PeriodEnd = &v
	return s
}

// SetPeriodStart sets the PeriodStart field's value.
func (s *ReportSummary) SetPeriodStart(v time.Time) *ReportSummary {
	s.PeriodStart = &v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *ReportSummary) SetProductName(v string) *ReportSummary {
	s.ProductName = &v
	return s
}

// SetSeries sets the Series field's value.
func (s *ReportSummary) SetSeries(v string) *ReportSummary {
	s.Series = &v
	return s
}

// SetState sets the State field's value.
func (s *ReportSummary) SetState(v string) *ReportSummary {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReportSummary) SetStatusMessage(v string) *ReportSummary {
	s.StatusMessage = &v
	return s
}

// SetUploadState sets the UploadState field's value.
func (s *ReportSummary) SetUploadState(v string) *ReportSummary {
	s.UploadState = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ReportSummary) SetVersion(v int64) *ReportSummary {
	s.Version = &v
	return s
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the affected resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the affected resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Code for the affected quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// Identifier of the affected resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the affected resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Code for the affected service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Code for the affected quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Number of seconds in which the caller can retry the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// Code for the affected service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that caused the error, if applicable.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Validation exception message and name.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Message describing why the field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// Name of validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AcceptanceTypePassthrough is a AcceptanceType enum value
	AcceptanceTypePassthrough = "PASSTHROUGH"

	// AcceptanceTypeExplicit is a AcceptanceType enum value
	AcceptanceTypeExplicit = "EXPLICIT"
)

// AcceptanceType_Values returns all elements of the AcceptanceType enum
func AcceptanceType_Values() []string {
	return []string{
		AcceptanceTypePassthrough,
		AcceptanceTypeExplicit,
	}
}

const (
	// NotificationSubscriptionStatusSubscribed is a NotificationSubscriptionStatus enum value
	NotificationSubscriptionStatusSubscribed = "SUBSCRIBED"

	// NotificationSubscriptionStatusNotSubscribed is a NotificationSubscriptionStatus enum value
	NotificationSubscriptionStatusNotSubscribed = "NOT_SUBSCRIBED"
)

// NotificationSubscriptionStatus_Values returns all elements of the NotificationSubscriptionStatus enum
func NotificationSubscriptionStatus_Values() []string {
	return []string{
		NotificationSubscriptionStatusSubscribed,
		NotificationSubscriptionStatusNotSubscribed,
	}
}

const (
	// PublishedStatePublished is a PublishedState enum value
	PublishedStatePublished = "PUBLISHED"

	// PublishedStateUnpublished is a PublishedState enum value
	PublishedStateUnpublished = "UNPUBLISHED"
)

// PublishedState_Values returns all elements of the PublishedState enum
func PublishedState_Values() []string {
	return []string{
		PublishedStatePublished,
		PublishedStateUnpublished,
	}
}

const (
	// UploadStateProcessing is a UploadState enum value
	UploadStateProcessing = "PROCESSING"

	// UploadStateComplete is a UploadState enum value
	UploadStateComplete = "COMPLETE"

	// UploadStateFailed is a UploadState enum value
	UploadStateFailed = "FAILED"

	// UploadStateFault is a UploadState enum value
	UploadStateFault = "FAULT"
)

// UploadState_Values returns all elements of the UploadState enum
func UploadState_Values() []string {
	return []string{
		UploadStateProcessing,
		UploadStateComplete,
		UploadStateFailed,
		UploadStateFault,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonInvalidToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidToken = "invalidToken"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonInvalidToken,
		ValidationExceptionReasonOther,
	}
}
