'use client';
'use strict';

var React = require('react');

function useHover() {
  const [hovered, setHovered] = React.useState(false);
  const ref = React.useRef(null);
  const onMouseEnter = React.useCallback(() => setHovered(true), []);
  const onMouseLeave = React.useCallback(() => setHovered(false), []);
  React.useEffect(() => {
    if (ref.current) {
      ref.current.addEventListener("mouseenter", onMouseEnter);
      ref.current.addEventListener("mouseleave", onMouseLeave);
      return () => {
        ref.current?.removeEventListener("mouseenter", onMouseEnter);
        ref.current?.removeEventListener("mouseleave", onMouseLeave);
      };
    }
    return void 0;
  }, [ref.current]);
  return { ref, hovered };
}

exports.useHover = useHover;
//# sourceMappingURL=use-hover.cjs.map
