"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  ArrayParam: () => ArrayParam,
  BooleanParam: () => BooleanParam,
  DateParam: () => DateParam,
  DateTimeParam: () => DateTimeParam,
  DelimitedArrayParam: () => DelimitedArrayParam,
  DelimitedNumericArrayParam: () => DelimitedNumericArrayParam,
  JsonParam: () => JsonParam,
  NumberParam: () => NumberParam,
  NumericArrayParam: () => NumericArrayParam,
  NumericObjectParam: () => NumericObjectParam,
  ObjectParam: () => ObjectParam,
  StringParam: () => StringParam,
  createEnumArrayParam: () => createEnumArrayParam,
  createEnumDelimitedArrayParam: () => createEnumDelimitedArrayParam,
  createEnumParam: () => createEnumParam,
  decodeArray: () => decodeArray,
  decodeArrayEnum: () => decodeArrayEnum,
  decodeBoolean: () => decodeBoolean,
  decodeDate: () => decodeDate,
  decodeDelimitedArray: () => decodeDelimitedArray,
  decodeDelimitedArrayEnum: () => decodeDelimitedArrayEnum,
  decodeDelimitedNumericArray: () => decodeDelimitedNumericArray,
  decodeEnum: () => decodeEnum,
  decodeJson: () => decodeJson,
  decodeNumber: () => decodeNumber,
  decodeNumericArray: () => decodeNumericArray,
  decodeNumericObject: () => decodeNumericObject,
  decodeObject: () => decodeObject,
  decodeQueryParams: () => decodeQueryParams,
  decodeString: () => decodeString,
  encodeArray: () => encodeArray,
  encodeBoolean: () => encodeBoolean,
  encodeDate: () => encodeDate,
  encodeDelimitedArray: () => encodeDelimitedArray,
  encodeDelimitedNumericArray: () => encodeDelimitedNumericArray,
  encodeJson: () => encodeJson,
  encodeNumber: () => encodeNumber,
  encodeNumericArray: () => encodeNumericArray,
  encodeNumericObject: () => encodeNumericObject,
  encodeObject: () => encodeObject,
  encodeQueryParams: () => encodeQueryParams,
  encodeString: () => encodeString,
  objectToSearchString: () => objectToSearchString,
  searchStringToObject: () => searchStringToObject,
  transformSearchStringJsonSafe: () => transformSearchStringJsonSafe,
  updateInLocation: () => updateInLocation,
  updateLocation: () => updateLocation,
  withDefault: () => withDefault
});
module.exports = __toCommonJS(src_exports);

// src/withDefault.ts
function withDefault(param, defaultValue, includeNull = true) {
  const decodeWithDefault = (...args) => {
    const decodedValue = param.decode(...args);
    if (decodedValue === void 0) {
      return defaultValue;
    }
    if (includeNull) {
      if (decodedValue === null) {
        return defaultValue;
      } else {
        return decodedValue;
      }
    }
    return decodedValue;
  };
  return { ...param, default: defaultValue, decode: decodeWithDefault };
}

// src/serialize.ts
function getEncodedValue(input, allowEmptyString) {
  if (input == null) {
    return input;
  }
  if (input.length === 0 && (!allowEmptyString || allowEmptyString && input !== "")) {
    return null;
  }
  const str = input instanceof Array ? input[0] : input;
  if (str == null) {
    return str;
  }
  if (!allowEmptyString && str === "") {
    return null;
  }
  return str;
}
function getEncodedValueArray(input) {
  if (input == null) {
    return input;
  }
  return input instanceof Array ? input : input === "" ? [] : [input];
}
function encodeDate(date) {
  if (date == null) {
    return date;
  }
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  return `${year}-${month < 10 ? `0${month}` : month}-${day < 10 ? `0${day}` : day}`;
}
function decodeDate(input) {
  const dateString = getEncodedValue(input);
  if (dateString == null)
    return dateString;
  const parts = dateString.split("-");
  if (parts[1] != null) {
    parts[1] -= 1;
  } else {
    parts[1] = 0;
    parts[2] = 1;
  }
  const decoded = new Date(...parts);
  if (isNaN(decoded.getTime())) {
    return null;
  }
  return decoded;
}
function encodeDateTime(date) {
  if (date == null) {
    return date;
  }
  return date.toISOString();
}
function decodeDateTime(input) {
  const dateString = getEncodedValue(input);
  if (dateString == null)
    return dateString;
  const decoded = new Date(dateString);
  if (isNaN(decoded.getTime())) {
    return null;
  }
  return decoded;
}
function encodeBoolean(bool) {
  if (bool == null) {
    return bool;
  }
  return bool ? "1" : "0";
}
function decodeBoolean(input) {
  const boolStr = getEncodedValue(input);
  if (boolStr == null)
    return boolStr;
  if (boolStr === "1") {
    return true;
  } else if (boolStr === "0") {
    return false;
  }
  return null;
}
function encodeNumber(num) {
  if (num == null) {
    return num;
  }
  return String(num);
}
function decodeNumber(input) {
  const numStr = getEncodedValue(input);
  if (numStr == null)
    return numStr;
  if (numStr === "")
    return null;
  const result = +numStr;
  return result;
}
function encodeString(str) {
  if (str == null) {
    return str;
  }
  return String(str);
}
function decodeString(input) {
  const str = getEncodedValue(input, true);
  if (str == null)
    return str;
  return String(str);
}
function decodeEnum(input, enumValues) {
  const str = decodeString(input);
  if (str == null)
    return str;
  return enumValues.includes(str) ? str : void 0;
}
function decodeArrayEnum(input, enumValues) {
  const arr = decodeArray(input);
  if (arr == null)
    return arr;
  if (!arr.length)
    return void 0;
  return arr.every((str) => str != null && enumValues.includes(str)) ? arr : void 0;
}
function decodeDelimitedArrayEnum(input, enumValues, entrySeparator = "_") {
  if (input != null && Array.isArray(input) && !input.length)
    return void 0;
  const arr = decodeDelimitedArray(input, entrySeparator);
  return decodeArrayEnum(arr, enumValues);
}
function encodeJson(any) {
  if (any == null) {
    return any;
  }
  return JSON.stringify(any);
}
function decodeJson(input) {
  const jsonStr = getEncodedValue(input);
  if (jsonStr == null)
    return jsonStr;
  let result = null;
  try {
    result = JSON.parse(jsonStr);
  } catch (e) {
  }
  return result;
}
function encodeArray(array) {
  if (array == null) {
    return array;
  }
  return array;
}
function decodeArray(input) {
  const arr = getEncodedValueArray(input);
  if (arr == null)
    return arr;
  return arr;
}
function encodeNumericArray(array) {
  if (array == null) {
    return array;
  }
  return array.map(String);
}
function decodeNumericArray(input) {
  const arr = decodeArray(input);
  if (arr == null)
    return arr;
  return arr.map((d) => d === "" || d == null ? null : +d);
}
function encodeDelimitedArray(array, entrySeparator = "_") {
  if (array == null) {
    return array;
  }
  return array.join(entrySeparator);
}
function decodeDelimitedArray(input, entrySeparator = "_") {
  const arrayStr = getEncodedValue(input, true);
  if (arrayStr == null)
    return arrayStr;
  if (arrayStr === "")
    return [];
  return arrayStr.split(entrySeparator);
}
var encodeDelimitedNumericArray = encodeDelimitedArray;
function decodeDelimitedNumericArray(arrayStr, entrySeparator = "_") {
  const decoded = decodeDelimitedArray(arrayStr, entrySeparator);
  if (decoded == null)
    return decoded;
  return decoded.map((d) => d === "" || d == null ? null : +d);
}
function encodeObject(obj, keyValSeparator = "-", entrySeparator = "_") {
  if (obj == null)
    return obj;
  if (!Object.keys(obj).length)
    return "";
  return Object.keys(obj).map((key) => `${key}${keyValSeparator}${obj[key]}`).join(entrySeparator);
}
function decodeObject(input, keyValSeparator = "-", entrySeparator = "_") {
  const objStr = getEncodedValue(input, true);
  if (objStr == null)
    return objStr;
  if (objStr === "")
    return {};
  const obj = {};
  const keyValSeparatorRegExp = new RegExp(`${keyValSeparator}(.*)`);
  objStr.split(entrySeparator).forEach((entryStr) => {
    const [key, value] = entryStr.split(keyValSeparatorRegExp);
    obj[key] = value;
  });
  return obj;
}
var encodeNumericObject = encodeObject;
function decodeNumericObject(input, keyValSeparator = "-", entrySeparator = "_") {
  const decoded = decodeObject(
    input,
    keyValSeparator,
    entrySeparator
  );
  if (decoded == null)
    return decoded;
  const decodedNumberObj = {};
  for (const key of Object.keys(decoded)) {
    decodedNumberObj[key] = decodeNumber(decoded[key]);
  }
  return decodedNumberObj;
}

// src/params.ts
var StringParam = {
  encode: encodeString,
  decode: decodeString
};
var createEnumParam = (enumValues) => ({
  encode: encodeString,
  decode: (input) => decodeEnum(input, enumValues)
});
var createEnumArrayParam = (enumValues) => ({
  encode: (text) => encodeArray(text == null || Array.isArray(text) ? text : [text]),
  decode: (input) => decodeArrayEnum(input, enumValues)
});
var createEnumDelimitedArrayParam = (enumValues, entrySeparator = "_") => ({
  encode: (text) => encodeDelimitedArray(
    text == null || Array.isArray(text) ? text : [text],
    entrySeparator
  ),
  decode: (input) => decodeDelimitedArrayEnum(input, enumValues, entrySeparator)
});
var NumberParam = {
  encode: encodeNumber,
  decode: decodeNumber
};
var ObjectParam = {
  encode: encodeObject,
  decode: decodeObject
};
var ArrayParam = {
  encode: encodeArray,
  decode: decodeArray
};
var NumericArrayParam = {
  encode: encodeNumericArray,
  decode: decodeNumericArray
};
var JsonParam = {
  encode: encodeJson,
  decode: decodeJson
};
var DateParam = {
  encode: encodeDate,
  decode: decodeDate,
  equals: (valueA, valueB) => {
    if (valueA === valueB)
      return true;
    if (valueA == null || valueB == null)
      return valueA === valueB;
    return valueA.getFullYear() === valueB.getFullYear() && valueA.getMonth() === valueB.getMonth() && valueA.getDate() === valueB.getDate();
  }
};
var DateTimeParam = {
  encode: encodeDateTime,
  decode: decodeDateTime,
  equals: (valueA, valueB) => {
    if (valueA === valueB)
      return true;
    if (valueA == null || valueB == null)
      return valueA === valueB;
    return valueA.valueOf() === valueB.valueOf();
  }
};
var BooleanParam = {
  encode: encodeBoolean,
  decode: decodeBoolean
};
var NumericObjectParam = {
  encode: encodeNumericObject,
  decode: decodeNumericObject
};
var DelimitedArrayParam = {
  encode: encodeDelimitedArray,
  decode: decodeDelimitedArray
};
var DelimitedNumericArrayParam = {
  encode: encodeDelimitedNumericArray,
  decode: decodeDelimitedNumericArray
};

// src/objectToSearchString.ts
function objectToSearchString(encodedParams) {
  const params = new URLSearchParams();
  const entries = Object.entries(encodedParams);
  for (const [key, value] of entries) {
    if (value === void 0)
      continue;
    if (value === null)
      continue;
    if (Array.isArray(value)) {
      for (const item of value) {
        params.append(key, item != null ? item : "");
      }
    } else {
      params.append(key, value);
    }
  }
  return params.toString();
}

// src/updateLocation.ts
var JSON_SAFE_CHARS = `{}[],":`.split("").map((d) => [d, encodeURIComponent(d)]);
function getHrefFromLocation(location, search) {
  let href = search;
  if (location.href) {
    try {
      const url = new URL(location.href);
      href = `${url.origin}${url.pathname}${search}`;
    } catch (e) {
      href = "";
    }
  }
  return href;
}
function transformSearchStringJsonSafe(searchString) {
  let str = searchString;
  for (let [char, code] of JSON_SAFE_CHARS) {
    str = str.replace(new RegExp("\\" + code, "g"), char);
  }
  return str;
}
function updateLocation(encodedQuery, location, objectToSearchStringFn = objectToSearchString) {
  let encodedSearchString = objectToSearchStringFn(encodedQuery);
  const search = encodedSearchString.length ? `?${encodedSearchString}` : "";
  const newLocation = {
    ...location,
    key: `${Date.now()}`,
    href: getHrefFromLocation(location, search),
    search,
    query: encodedQuery
  };
  return newLocation;
}
function updateInLocation(encodedQueryReplacements, location, objectToSearchStringFn = objectToSearchString, searchStringToObjectFn = searchStringToObject) {
  const currQuery = searchStringToObjectFn(location.search);
  const newQuery = {
    ...currQuery,
    ...encodedQueryReplacements
  };
  return updateLocation(newQuery, location, objectToSearchStringFn);
}

// src/encodeQueryParams.ts
function encodeQueryParams(paramConfigMap, query) {
  const encodedQuery = {};
  const paramNames = Object.keys(query);
  for (const paramName of paramNames) {
    const decodedValue = query[paramName];
    if (!paramConfigMap[paramName]) {
      encodedQuery[paramName] = decodedValue == null ? decodedValue : String(decodedValue);
    } else {
      encodedQuery[paramName] = paramConfigMap[paramName].encode(query[paramName]);
    }
  }
  return encodedQuery;
}

// src/decodeQueryParams.ts
function decodeQueryParams(paramConfigMap, encodedQuery) {
  const decodedQuery = {};
  const paramNames = Object.keys(paramConfigMap);
  for (const encodedKey of Object.keys(encodedQuery)) {
    if (paramConfigMap[encodedKey] == null) {
      paramNames.push(encodedKey);
    }
  }
  for (const paramName of paramNames) {
    const encodedValue = encodedQuery[paramName];
    if (!paramConfigMap[paramName]) {
      if (true) {
        console.warn(
          `Passing through parameter ${paramName} during decoding since it was not configured.`
        );
      }
      decodedQuery[paramName] = encodedValue;
    } else {
      decodedQuery[paramName] = paramConfigMap[paramName].decode(encodedValue);
    }
  }
  return decodedQuery;
}

// src/searchStringToObject.ts
function searchStringToObject(searchString) {
  const params = new URLSearchParams(searchString);
  const parsed = {};
  for (let [key, value] of params) {
    if (Object.prototype.hasOwnProperty.call(parsed, key)) {
      if (Array.isArray(parsed[key])) {
        parsed[key].push(value);
      } else {
        parsed[key] = [parsed[key], value];
      }
    } else {
      parsed[key] = value;
    }
  }
  return parsed;
}
//# sourceMappingURL=index.js.map
