package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LookupEvents invokes the actiontrail.LookupEvents API synchronously
func (client *Client) LookupEvents(request *LookupEventsRequest) (response *LookupEventsResponse, err error) {
	response = CreateLookupEventsResponse()
	err = client.DoAction(request, response)
	return
}

// LookupEventsWithChan invokes the actiontrail.LookupEvents API asynchronously
func (client *Client) LookupEventsWithChan(request *LookupEventsRequest) (<-chan *LookupEventsResponse, <-chan error) {
	responseChan := make(chan *LookupEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LookupEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LookupEventsWithCallback invokes the actiontrail.LookupEvents API asynchronously
func (client *Client) LookupEventsWithCallback(request *LookupEventsRequest, callback func(response *LookupEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LookupEventsResponse
		var err error
		defer close(result)
		response, err = client.LookupEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LookupEventsRequest is the request struct for api LookupEvents
type LookupEventsRequest struct {
	*requests.RpcRequest
	EndTime         string                         `position:"Query" name:"EndTime"`
	StartTime       string                         `position:"Query" name:"StartTime"`
	NextToken       string                         `position:"Query" name:"NextToken"`
	LookupAttribute *[]LookupEventsLookupAttribute `position:"Query" name:"LookupAttribute"  type:"Repeated"`
	MaxResults      string                         `position:"Query" name:"MaxResults"`
	Direction       string                         `position:"Query" name:"Direction"`
}

// LookupEventsLookupAttribute is a repeated param struct in LookupEventsRequest
type LookupEventsLookupAttribute struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// LookupEventsResponse is the response struct for api LookupEvents
type LookupEventsResponse struct {
	*responses.BaseResponse
	EndTime   string                   `json:"EndTime" xml:"EndTime"`
	NextToken string                   `json:"NextToken" xml:"NextToken"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	StartTime string                   `json:"StartTime" xml:"StartTime"`
	Events    []map[string]interface{} `json:"Events" xml:"Events"`
}

// CreateLookupEventsRequest creates a request to invoke LookupEvents API
func CreateLookupEventsRequest() (request *LookupEventsRequest) {
	request = &LookupEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "LookupEvents", "actiontrail", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLookupEventsResponse creates a response to parse from LookupEvents response
func CreateLookupEventsResponse() (response *LookupEventsResponse) {
	response = &LookupEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
