package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDynamicTagGroup invokes the cms.CreateDynamicTagGroup API synchronously
func (client *Client) CreateDynamicTagGroup(request *CreateDynamicTagGroupRequest) (response *CreateDynamicTagGroupResponse, err error) {
	response = CreateCreateDynamicTagGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDynamicTagGroupWithChan invokes the cms.CreateDynamicTagGroup API asynchronously
func (client *Client) CreateDynamicTagGroupWithChan(request *CreateDynamicTagGroupRequest) (<-chan *CreateDynamicTagGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDynamicTagGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDynamicTagGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDynamicTagGroupWithCallback invokes the cms.CreateDynamicTagGroup API asynchronously
func (client *Client) CreateDynamicTagGroupWithCallback(request *CreateDynamicTagGroupRequest, callback func(response *CreateDynamicTagGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDynamicTagGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDynamicTagGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDynamicTagGroupRequest is the request struct for api CreateDynamicTagGroup
type CreateDynamicTagGroupRequest struct {
	*requests.RpcRequest
	EnableSubscribeEvent       requests.Boolean                     `position:"Query" name:"EnableSubscribeEvent"`
	MatchExpressFilterRelation string                               `position:"Query" name:"MatchExpressFilterRelation"`
	EnableInstallAgent         requests.Boolean                     `position:"Query" name:"EnableInstallAgent"`
	MatchExpress               *[]CreateDynamicTagGroupMatchExpress `position:"Query" name:"MatchExpress"  type:"Repeated"`
	ContactGroupList           *[]string                            `position:"Query" name:"ContactGroupList"  type:"Repeated"`
	TemplateIdList             *[]string                            `position:"Query" name:"TemplateIdList"  type:"Repeated"`
	TagKey                     string                               `position:"Query" name:"TagKey"`
	TagRegionId                string                               `position:"Query" name:"TagRegionId"`
}

// CreateDynamicTagGroupMatchExpress is a repeated param struct in CreateDynamicTagGroupRequest
type CreateDynamicTagGroupMatchExpress struct {
	TagValue              string `name:"TagValue"`
	TagValueMatchFunction string `name:"TagValueMatchFunction"`
}

// CreateDynamicTagGroupResponse is the response struct for api CreateDynamicTagGroup
type CreateDynamicTagGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateDynamicTagGroupRequest creates a request to invoke CreateDynamicTagGroup API
func CreateCreateDynamicTagGroupRequest() (request *CreateDynamicTagGroupRequest) {
	request = &CreateDynamicTagGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateDynamicTagGroup", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDynamicTagGroupResponse creates a response to parse from CreateDynamicTagGroup response
func CreateCreateDynamicTagGroupResponse() (response *CreateDynamicTagGroupResponse) {
	response = &CreateDynamicTagGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
