package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateJob invokes the foas.ValidateJob API synchronously
func (client *Client) ValidateJob(request *ValidateJobRequest) (response *ValidateJobResponse, err error) {
	response = CreateValidateJobResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateJobWithChan invokes the foas.ValidateJob API asynchronously
func (client *Client) ValidateJobWithChan(request *ValidateJobRequest) (<-chan *ValidateJobResponse, <-chan error) {
	responseChan := make(chan *ValidateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateJobWithCallback invokes the foas.ValidateJob API asynchronously
func (client *Client) ValidateJobWithCallback(request *ValidateJobRequest, callback func(response *ValidateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateJobResponse
		var err error
		defer close(result)
		response, err = client.ValidateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateJobRequest is the request struct for api ValidateJob
type ValidateJobRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	JobName     string `position:"Path" name:"jobName"`
}

// ValidateJobResponse is the response struct for api ValidateJob
type ValidateJobResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	JobInOut  JobInOut `json:"JobInOut" xml:"JobInOut"`
}

// CreateValidateJobRequest creates a request to invoke ValidateJob API
func CreateValidateJobRequest() (request *ValidateJobRequest) {
	request = &ValidateJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ValidateJob", "/api/v2/projects/[projectName]/jobs/[jobName]/validate", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateValidateJobResponse creates a response to parse from ValidateJob response
func CreateValidateJobResponse() (response *ValidateJobResponse) {
	response = &ValidateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
