package com.tipcj;

public class Poll {
	/**
	 * Epoll event masks
	 */
	public static final short EPOLLIN         = 0x00000001;
	public static final short EPOLLPRI        = 0x00000002;
	public static final short EPOLLOUT        = 0x00000004;
	public static final short EPOLLERR        = 0x00000008;
	public static final short EPOLLHUP        = 0x00000010;
	public static final short EPOLLNVAL       = 0x00000020;
	public static final short EPOLLRDNORM     = 0x00000040;
	public static final short EPOLLRDBAND     = 0x00000080;
	public static final short EPOLLWRNORM     = 0x00000100;
	public static final short EPOLLWRBAND     = 0x00000200;
	public static final short EPOLLMSG        = 0x00000400;
	public static final short EPOLLRDHUP      = 0x00002000;

	/**
	 * JNI instance
	 */
	static {
		tipcj = TipcBaseApi.getInstance();
	}

	public static final int poll(int fd, short events, java.lang.Integer revents, int timeout) {
		return tipcj.tipc_poll(fd, events, revents, timeout);
	}

	public static final int pollset(int[] fds, short events, java.lang.Integer[] revents, int timeout) {
		short[] jevents = new short[fds.length];
		for (int i=0; i<fds.length; i++) {
			jevents[i] = events;
		}
		return pollset(fds, jevents, revents, timeout);
	}

	public static final int pollset(int[] fds, short[] events, java.lang.Integer[] revents, int timeout) {
		for (int i=0; i<revents.length; i++) {
			revents[i] = 0;
		}
		return tipcj.tipc_pollset(fds, events, revents, timeout);
	}

	private static TipcBaseApi tipcj;
}
