/**
 * ------------------------------------------------------------------------
 *
 * Copyright (c) 2018, Ericsson Canada
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Ericsson Canada nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Version 0.1: Jon Maloy, 2018
 *
 * ------------------------------------------------------------------------
 */
package com.tipcj;

/**
 * @author Hoang Le (hoang.h.le@dektech.com.au)
 *
 */
public class TipcSrvConn {
	/**
	 * JNI instance
	 */
	static {
		tipcj = TipcBaseApi.getInstance();
	}

	@SuppressWarnings("unused")
	private TipcSrvConn() {};

	/**
	 * Constructor to connect topology server
	 * @param node
	 */
	public TipcSrvConn(long node) {
		this.Fd = SrvConn(node);
	}

	public TipcSrvConn(long node, ServiceType srvType) {
		this(node);
		if (this.Fd <= 0) {
			return;
		}

		if (srvType.equals(ServiceType.TIPC_TOP_SRV) || srvType.equals(ServiceType.TIPC_LINK_STATE)) {
			this.filterEvtAll = true;
		}
		/**
		 * Subscribe to subscription(s)
		 */
		this.SrvScr(srvType.val, 0, Integer.MAX_VALUE, this.filterEvtAll, -1);
	}

	public int getFd() {
		return this.Fd;
	}

	/** Topology Server:
	 * - Expiration time in [ms]
	 * - If (expire < 0) subscription never expires
	 */
	private int SrvConn(long node) {
		return tipcj.tipc_topsrv_conn(node);
	}

	public int SrvScr(long type, long lower, long upper, boolean filterAll, int expire) {
		if (this.Fd <=0 ) {
			return -1;
		}
		return tipcj.tipc_srv_subscr(this.Fd, type, lower, upper, filterAll, expire);
	}

	public int GetEvt(TipcAddr srv, TipcAddr id, java.lang.Integer up, java.lang.Integer expired) {
		return tipcj.tipc_srv_evt(this.Fd, srv, id, up, expired);
	}

	public static boolean SrvWait(TipcAddr srv, int expire) {
		return tipcj.tipc_srv_wait(srv, expire);
	}

	public void Close() {
		tipcj.tipc_close(this.Fd);
	}

	private static TipcBaseApi tipcj;
	protected int Fd = 0;
	protected boolean filterEvtAll = false;
}
