/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters;

import java.io.IOException;
import java.math.BigDecimal;
import org.joda.time.Instant;
import org.logstash.Event;
import org.logstash.filters.ParserExecutor;
import org.logstash.filters.parser.TimestampParser;

class NumericParserExecutor
implements ParserExecutor {
    private TimestampParser parser;

    public NumericParserExecutor(TimestampParser parser) {
        this.parser = parser;
    }

    @Override
    public Instant execute(Object input, Event event) throws IOException {
        if (input instanceof String) {
            return this.parser.parse((String)input);
        }
        if (input instanceof Long) {
            return this.parser.parse((Long)input);
        }
        if (input instanceof Integer) {
            return this.parser.parse(((Integer)input).longValue());
        }
        if (input instanceof Double) {
            return this.parser.parse((Double)input);
        }
        if (input instanceof BigDecimal) {
            return this.parser.parse((BigDecimal)input);
        }
        throw new IllegalArgumentException("Cannot parse date for value of type " + input.getClass().getName());
    }
}

