/*
 * Decompiled with CFR 0.152.
 */
package org.nio4r;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ByteBuffer
extends RubyObject {
    private static final long serialVersionUID = -6903439483039149324L;
    private java.nio.ByteBuffer byteBuffer;

    public static RaiseException newOverflowError(ThreadContext threadContext, String string) {
        RubyClass rubyClass = threadContext.runtime.getModule("NIO").getClass("ByteBuffer").getClass("OverflowError");
        return threadContext.runtime.newRaiseException(rubyClass, string);
    }

    public static RaiseException newUnderflowError(ThreadContext threadContext, String string) {
        RubyClass rubyClass = threadContext.runtime.getModule("NIO").getClass("ByteBuffer").getClass("UnderflowError");
        return threadContext.runtime.newRaiseException(rubyClass, string);
    }

    public static RaiseException newMarkUnsetError(ThreadContext threadContext, String string) {
        RubyClass rubyClass = threadContext.runtime.getModule("NIO").getClass("ByteBuffer").getClass("MarkUnsetError");
        return threadContext.runtime.newRaiseException(rubyClass, string);
    }

    public ByteBuffer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.byteBuffer = java.nio.ByteBuffer.allocate(RubyNumeric.num2int((IRubyObject)iRubyObject));
        return this;
    }

    @JRubyMethod
    public IRubyObject clear(ThreadContext threadContext) {
        this.byteBuffer.clear();
        return this;
    }

    @JRubyMethod(name={"position"})
    public IRubyObject getPosition(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.byteBuffer.position());
    }

    @JRubyMethod(name={"position="})
    public IRubyObject setPosition(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        if (n < 0) {
            throw threadContext.runtime.newArgumentError("negative position given");
        }
        if (n > this.byteBuffer.limit()) {
            throw threadContext.runtime.newArgumentError("specified position exceeds limit");
        }
        try {
            this.byteBuffer.position(n);
            return iRubyObject;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.runtime.newArgumentError(illegalArgumentException.getLocalizedMessage());
        }
    }

    @JRubyMethod(name={"limit"})
    public IRubyObject getLimit(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.byteBuffer.limit());
    }

    @JRubyMethod(name={"limit="})
    public IRubyObject setLimit(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        if (n < 0) {
            throw threadContext.runtime.newArgumentError("negative limit given");
        }
        if (n > this.byteBuffer.capacity()) {
            throw threadContext.runtime.newArgumentError("specified limit exceeds capacity");
        }
        try {
            this.byteBuffer.limit(n);
            return iRubyObject;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.runtime.newArgumentError(illegalArgumentException.getLocalizedMessage());
        }
    }

    @JRubyMethod(name={"capacity", "size"})
    public IRubyObject capacity(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.byteBuffer.capacity());
    }

    @JRubyMethod
    public IRubyObject remaining(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.byteBuffer.remaining());
    }

    @JRubyMethod(name={"full?"})
    public IRubyObject isFull(ThreadContext threadContext) {
        if (this.byteBuffer.hasRemaining()) {
            return threadContext.getRuntime().getFalse();
        }
        return threadContext.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject get(ThreadContext threadContext) {
        return this.get(threadContext, (IRubyObject)threadContext.getRuntime().newFixnum(this.byteBuffer.remaining()));
    }

    @JRubyMethod
    public IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        byte[] byArray = new byte[n];
        try {
            this.byteBuffer.get(byArray);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw ByteBuffer.newUnderflowError(threadContext, "not enough data in buffer");
        }
        return RubyString.newString((Ruby)threadContext.getRuntime(), (byte[])byArray);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject fetch(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
        if (n < 0) {
            throw threadContext.runtime.newArgumentError("negative index given");
        }
        if (n >= this.byteBuffer.limit()) {
            throw threadContext.runtime.newArgumentError("index exceeds limit");
        }
        return threadContext.getRuntime().newFixnum((int)this.byteBuffer.get(n));
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject put(ThreadContext threadContext, IRubyObject iRubyObject) {
        try {
            this.byteBuffer.put(iRubyObject.convertToString().getByteList().bytes());
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw ByteBuffer.newOverflowError(threadContext, "buffer is full");
        }
        return this;
    }

    @JRubyMethod(name={"read_from"})
    public IRubyObject readFrom(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        Channel channel = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject).getChannel();
        if (!this.byteBuffer.hasRemaining()) {
            throw ByteBuffer.newOverflowError(threadContext, "buffer is full");
        }
        if (!(channel instanceof ReadableByteChannel) || !(channel instanceof SelectableChannel)) {
            throw ruby.newArgumentError("unsupported IO object: " + iRubyObject.getType().toString());
        }
        try {
            ((SelectableChannel)channel).configureBlocking(false);
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
        try {
            int n = ((ReadableByteChannel)channel).read(this.byteBuffer);
            if (n >= 0) {
                return ruby.newFixnum(n);
            }
            throw ruby.newEOFError();
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
    }

    @JRubyMethod(name={"write_to"})
    public IRubyObject writeTo(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        Channel channel = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject).getChannel();
        if (!this.byteBuffer.hasRemaining()) {
            throw ByteBuffer.newUnderflowError(threadContext, "not enough data in buffer");
        }
        if (!(channel instanceof WritableByteChannel) || !(channel instanceof SelectableChannel)) {
            throw ruby.newArgumentError("unsupported IO object: " + iRubyObject.getType().toString());
        }
        try {
            ((SelectableChannel)channel).configureBlocking(false);
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
        try {
            int n = ((WritableByteChannel)channel).write(this.byteBuffer);
            if (n >= 0) {
                return ruby.newFixnum(n);
            }
            throw ruby.newEOFError();
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
    }

    @JRubyMethod
    public IRubyObject flip(ThreadContext threadContext) {
        this.byteBuffer.flip();
        return this;
    }

    @JRubyMethod
    public IRubyObject rewind(ThreadContext threadContext) {
        this.byteBuffer.rewind();
        return this;
    }

    @JRubyMethod
    public IRubyObject mark(ThreadContext threadContext) {
        this.byteBuffer.mark();
        return this;
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext threadContext) {
        try {
            this.byteBuffer.reset();
            return this;
        }
        catch (InvalidMarkException invalidMarkException) {
            throw ByteBuffer.newMarkUnsetError(threadContext, "mark has not been set");
        }
    }

    @JRubyMethod
    public IRubyObject compact(ThreadContext threadContext) {
        this.byteBuffer.compact();
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext threadContext, Block block) {
        for (int i = 0; i < this.byteBuffer.limit(); ++i) {
            block.call(threadContext, (IRubyObject)threadContext.getRuntime().newFixnum((int)this.byteBuffer.get(i)));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext threadContext) {
        return threadContext.runtime.newString(String.format("#<%s:0x%x @position=%d @limit=%d @capacity=%d>", this.getType().toString(), System.identityHashCode((Object)this), this.byteBuffer.position(), this.byteBuffer.limit(), this.byteBuffer.capacity()));
    }
}

