/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ExtensionRegistry {
    private final Map<RubyModule, ExtensionEntry> extensionsByModule;
    private final Map<RubyModule, ExtensionEntry> extensionsByAncestor;
    private final ExtensionEntry[] extensionsByTypeId;

    public ExtensionRegistry() {
        this(new HashMap<RubyModule, ExtensionEntry>());
    }

    private ExtensionRegistry(Map<RubyModule, ExtensionEntry> map) {
        this.extensionsByModule = new HashMap<RubyModule, ExtensionEntry>(map);
        this.extensionsByAncestor = new HashMap<RubyModule, ExtensionEntry>();
        this.extensionsByTypeId = new ExtensionEntry[256];
        for (ExtensionEntry extensionEntry : map.values()) {
            if (!extensionEntry.hasUnpacker()) continue;
            this.extensionsByTypeId[extensionEntry.getTypeId() + 128] = extensionEntry;
        }
    }

    public ExtensionRegistry dup() {
        return new ExtensionRegistry(this.extensionsByModule);
    }

    public IRubyObject toInternalPackerRegistry(ThreadContext threadContext) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)threadContext.runtime);
        for (RubyModule rubyModule : this.extensionsByModule.keySet()) {
            ExtensionEntry extensionEntry = this.extensionsByModule.get(rubyModule);
            if (!extensionEntry.hasPacker()) continue;
            rubyHash.put((Object)rubyModule, extensionEntry.toPackerTuple(threadContext));
        }
        return rubyHash;
    }

    public IRubyObject toInternalUnpackerRegistry(ThreadContext threadContext) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)threadContext.runtime);
        for (int i = 0; i < 256; ++i) {
            ExtensionEntry extensionEntry = this.extensionsByTypeId[i];
            if (extensionEntry == null || !extensionEntry.hasUnpacker()) continue;
            RubyFixnum rubyFixnum = RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)(i - 128));
            rubyHash.put((Object)rubyFixnum, extensionEntry.toUnpackerTuple(threadContext));
        }
        return rubyHash;
    }

    public void put(RubyModule rubyModule, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        ExtensionEntry extensionEntry = new ExtensionEntry(rubyModule, n, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
        this.extensionsByModule.put(rubyModule, extensionEntry);
        this.extensionsByTypeId[n + 128] = extensionEntry;
        this.extensionsByAncestor.clear();
    }

    public IRubyObject lookupUnpackerByTypeId(int n) {
        ExtensionEntry extensionEntry = this.extensionsByTypeId[n + 128];
        if (extensionEntry != null && extensionEntry.hasUnpacker()) {
            return extensionEntry.getUnpackerProc();
        }
        return null;
    }

    public IRubyObject[] lookupPackerForObject(IRubyObject iRubyObject) {
        RubyClass rubyClass = null;
        rubyClass = iRubyObject.getMetaClass();
        IRubyObject[] iRubyObjectArray = this.fetchEntryByModule((RubyModule)rubyClass);
        if (iRubyObjectArray != null) {
            return iRubyObjectArray;
        }
        RubyClass rubyClass2 = iRubyObject.getType();
        if (rubyClass2 != rubyClass && (iRubyObjectArray = this.fetchEntryByModule((RubyModule)rubyClass2)) != null) {
            return iRubyObjectArray;
        }
        ExtensionEntry extensionEntry = this.findEntryByModuleOrAncestor((RubyModule)rubyClass);
        if (extensionEntry != null && extensionEntry.hasPacker()) {
            this.extensionsByAncestor.put(extensionEntry.getExtensionModule(), extensionEntry);
            return extensionEntry.toPackerProcTypeIdPair(rubyClass.getRuntime().getCurrentContext());
        }
        return null;
    }

    private IRubyObject[] fetchEntryByModule(RubyModule rubyModule) {
        ExtensionEntry extensionEntry = this.extensionsByModule.get(rubyModule);
        if (extensionEntry == null) {
            extensionEntry = this.extensionsByAncestor.get(rubyModule);
        }
        if (extensionEntry != null && extensionEntry.hasPacker()) {
            return extensionEntry.toPackerProcTypeIdPair(rubyModule.getRuntime().getCurrentContext());
        }
        return null;
    }

    private ExtensionEntry findEntryByModuleOrAncestor(RubyModule rubyModule) {
        ThreadContext threadContext = rubyModule.getRuntime().getCurrentContext();
        for (RubyModule rubyModule2 : this.extensionsByModule.keySet()) {
            RubyArray rubyArray = (RubyArray)rubyModule.callMethod(threadContext, "ancestors");
            if (!rubyArray.callMethod(threadContext, "include?", (IRubyObject)rubyModule2).isTrue()) continue;
            return this.extensionsByModule.get(rubyModule2);
        }
        return null;
    }

    private static class ExtensionEntry {
        private final RubyModule mod;
        private final int typeId;
        private final IRubyObject packerProc;
        private final IRubyObject packerArg;
        private final IRubyObject unpackerProc;
        private final IRubyObject unpackerArg;

        public ExtensionEntry(RubyModule rubyModule, int n, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            this.mod = rubyModule;
            this.typeId = n;
            this.packerProc = iRubyObject;
            this.packerArg = iRubyObject2;
            this.unpackerProc = iRubyObject3;
            this.unpackerArg = iRubyObject4;
        }

        public RubyModule getExtensionModule() {
            return this.mod;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public boolean hasPacker() {
            return this.packerProc != null;
        }

        public boolean hasUnpacker() {
            return this.unpackerProc != null;
        }

        public IRubyObject getPackerProc() {
            return this.packerProc;
        }

        public IRubyObject getUnpackerProc() {
            return this.unpackerProc;
        }

        public RubyArray<?> toPackerTuple(ThreadContext threadContext) {
            return threadContext.runtime.newArray(new IRubyObject[]{threadContext.runtime.newFixnum(this.typeId), this.packerProc, this.packerArg});
        }

        public RubyArray<?> toUnpackerTuple(ThreadContext threadContext) {
            return threadContext.runtime.newArray(new IRubyObject[]{this.mod, this.unpackerProc, this.unpackerArg});
        }

        public IRubyObject[] toPackerProcTypeIdPair(ThreadContext threadContext) {
            return new IRubyObject[]{this.packerProc, threadContext.runtime.newFixnum(this.typeId)};
        }
    }
}

