/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.XmlSaxParserContext;
import nokogiri.internals.NokogiriHandler;
import nokogiri.internals.NokogiriHelpers;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.cyberneko.html.parsers.SAXParser;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::HTML4::SAX::ParserContext"}, parent="Nokogiri::XML::SAX::ParserContext")
public class Html4SaxParserContext
extends XmlSaxParserContext {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset(()|\\s)=(()|\\s)([a-z]|-|_|\\d)+", 2);

    static Html4SaxParserContext newInstance(Ruby ruby, RubyClass rubyClass) {
        Html4SaxParserContext html4SaxParserContext = new Html4SaxParserContext(ruby, rubyClass);
        html4SaxParserContext.initialize(ruby);
        return html4SaxParserContext;
    }

    public Html4SaxParserContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @Override
    protected AbstractSAXParser createParser() throws SAXException {
        SAXParser sAXParser = new SAXParser();
        try {
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
            sAXParser.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
            return sAXParser;
        }
        catch (SAXException sAXException) {
            throw new SAXException("Problem while creating HTML4 SAX Parser: " + sAXException.toString());
        }
    }

    @JRubyMethod(name={"memory"}, meta=true)
    public static IRubyObject parse_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Html4SaxParserContext html4SaxParserContext = Html4SaxParserContext.newInstance(threadContext.runtime, (RubyClass)iRubyObject);
        String string = Html4SaxParserContext.findEncodingName(threadContext, iRubyObject3);
        if (string != null) {
            CharSequence charSequence = Html4SaxParserContext.applyEncoding(NokogiriHelpers.rubyStringToString(iRubyObject2.convertToString()), string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(charSequence.toString().getBytes());
            html4SaxParserContext.setInputSource(byteArrayInputStream);
            html4SaxParserContext.getInputSource().setEncoding(string);
        }
        return html4SaxParserContext;
    }

    private static String findEncodingName(int n) {
        EncodingType encodingType = EncodingType.get(n);
        if (encodingType == null) {
            return null;
        }
        assert (encodingType.value == n);
        return encodingType.name;
    }

    private static String findEncodingName(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = null;
        if (iRubyObject instanceof RubyString) {
            string = NokogiriHelpers.rubyStringToString((RubyString)iRubyObject);
        } else if (iRubyObject instanceof RubyFixnum) {
            string = Html4SaxParserContext.findEncodingName(RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)iRubyObject)));
        }
        if (string == null) {
            return null;
        }
        try {
            return Charset.forName(string).displayName();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw threadContext.getRuntime().newEncodingCompatibilityError(string + "is not supported");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw threadContext.getRuntime().newEncodingError(illegalCharsetNameException.getMessage());
        }
    }

    private static CharSequence applyEncoding(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (Html4SaxParserContext.containsIgnoreCase(string, "charset")) {
            Matcher matcher = CHARSET_PATTERN.matcher(string);
            while (matcher.find()) {
                n = matcher.start();
                n2 = matcher.end();
            }
        }
        if (n != n2) {
            return new StringBuilder(string).replace(n, n2, "charset=" + string2);
        }
        return string;
    }

    private static boolean containsIgnoreCase(String string, String string2) {
        int n = string2.length();
        int n2 = string.length() - n;
        if (n == 0) {
            return true;
        }
        char c = Character.toLowerCase(string2.charAt(0));
        char c2 = Character.toUpperCase(string2.charAt(0));
        for (int i = 0; i <= n2; ++i) {
            char c3 = string.charAt(i);
            if (c3 != c && Character.toLowerCase(c3) != c && Character.toUpperCase(c3) != c2 || !string.regionMatches(true, i + 1, string2, 1, n - 1)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"file"}, meta=true)
    public static IRubyObject parse_file(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Html4SaxParserContext html4SaxParserContext = Html4SaxParserContext.newInstance(threadContext.runtime, (RubyClass)iRubyObject);
        html4SaxParserContext.setInputSourceFile(threadContext, iRubyObject2);
        String string = Html4SaxParserContext.findEncodingName(threadContext, iRubyObject3);
        if (string != null) {
            html4SaxParserContext.getInputSource().setEncoding(string);
        }
        return html4SaxParserContext;
    }

    @JRubyMethod(name={"io"}, meta=true)
    public static IRubyObject parse_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Html4SaxParserContext html4SaxParserContext = Html4SaxParserContext.newInstance(threadContext.runtime, (RubyClass)iRubyObject);
        html4SaxParserContext.setIOInputSource(threadContext, iRubyObject2, threadContext.nil);
        String string = Html4SaxParserContext.findEncodingName(threadContext, iRubyObject3);
        if (string != null) {
            html4SaxParserContext.getInputSource().setEncoding(string);
        }
        return html4SaxParserContext;
    }

    static Html4SaxParserContext parse_stream(Ruby ruby, RubyClass rubyClass, InputStream inputStream) {
        Html4SaxParserContext html4SaxParserContext = Html4SaxParserContext.newInstance(ruby, rubyClass);
        html4SaxParserContext.setInputSource(inputStream);
        return html4SaxParserContext;
    }

    @Override
    protected void preParse(Ruby ruby, IRubyObject iRubyObject, NokogiriHandler nokogiriHandler) {
    }

    public static enum EncodingType {
        NONE(0, "NONE"),
        UTF_8(1, "UTF-8"),
        UTF16LE(2, "UTF16LE"),
        UTF16BE(3, "UTF16BE"),
        UCS4LE(4, "UCS4LE"),
        UCS4BE(5, "UCS4BE"),
        EBCDIC(6, "EBCDIC"),
        UCS4_2143(7, "ICS4-2143"),
        UCS4_3412(8, "UCS4-3412"),
        UCS2(9, "UCS2"),
        ISO_8859_1(10, "ISO-8859-1"),
        ISO_8859_2(11, "ISO-8859-2"),
        ISO_8859_3(12, "ISO-8859-3"),
        ISO_8859_4(13, "ISO-8859-4"),
        ISO_8859_5(14, "ISO-8859-5"),
        ISO_8859_6(15, "ISO-8859-6"),
        ISO_8859_7(16, "ISO-8859-7"),
        ISO_8859_8(17, "ISO-8859-8"),
        ISO_8859_9(18, "ISO-8859-9"),
        ISO_2022_JP(19, "ISO-2022-JP"),
        SHIFT_JIS(20, "SHIFT-JIS"),
        EUC_JP(21, "EUC-JP"),
        ASCII(22, "ASCII");

        private final int value;
        private final String name;
        private static transient EncodingType[] values;

        private EncodingType(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        static EncodingType get(int n) {
            EncodingType[] encodingTypeArray = values;
            if (encodingTypeArray == null) {
                values = encodingTypeArray = EncodingType.values();
            }
            if (n >= 0 && n < encodingTypeArray.length) {
                return encodingTypeArray[n];
            }
            return null;
        }
    }
}

