// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Collectable_sprite.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Collectable_sprite::Collectable_sprite() : animated (false) 
{
    // ...

} // FS::Collectable_sprite::Collectable_sprite
        
// ******************
// *** DESTRUCTOR ***
// ******************
FS::Collectable_sprite::~Collectable_sprite()
{
    // ...
    
} // FS::Collectable_sprite::~Collectable_sprite()




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

bool FS::Collectable_sprite::calc_virtual_x( const ScrollingData& sd, int row )
{
    // For the purposes of the following code, x-coord should
    // be < SCREEN_WIDTH. For want of a better name, we'll call this
    // value virtual_x, because it's the 'onscreen' value as used by SDL.
    if ( x >= SCREEN_WIDTH )
    {
        virtual_x = -(sd.row_lengths_in_pixels[row] - x);
    }
    else
    {
        virtual_x = x;
    } // if ... else
    
    return ( virtual_x + width >= 0 );

} // FS::Collectable_sprite::calc_virtual_x

// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************
