Scdtools - Tools for Scdaemon and OpenPGP smartcards
====================================================

Scdtools is a set of utility tools to work with Scdaemon, the smartcard
daemon of the [GnuPG project](http://www.gnupg.org/), and [OpenPGP
smartcards](http://g10code.com/docs/openpgp-card-2.0.pdf).


Scdrand - Extract random numbers from a smartcard
-------------------------------------------------
_Scdrand_ obtains up to 256 bytes of random data from a ISO7816-compliant
smartcard and adds them to the kernel entropy pool.

It uses Scdaemon to send a `GET CHALLENGE` to the smartcard. As per
ISO 7816-4, the smartcard replies with random bytes, which _scdrand_ then
sends to the Linux kernel entropy pool through the RNDADDENTROPY ioctl
call on `/dev/random`.

Since that call requires root privileges, _scdrand_ is installed with
the setuid bit set. To mitigate risks associated with running as root,
the program forks itself at startup and only the child retains the root
privileges needed to write to `/dev/random`. The parent process, in
charge of communicating with the smartcard, then runs with the
privileges on the calling user.

### Usage
The most basic usage of _scdrand_ is as follows:

```sh
$ scdrand 32
```

The program will request 32 random bytes from the card, feed them to the
entropy pool, then quits. You can request from 1 to 256 bytes.

With the `-l, --loop` option, _scdrand_ will not quit, but will
periodically request random bytes from the card and feed them to the
pool. With the `-t, --threshold` option, _scdrand_ will attempt to feed
the pool only if the available entropy in the pool falls below a
specified threshold. So in the following example:

```sh
$ scdrand -l -i 1 -t 512 256
```

_scdrand_ will check the state of the entropy pool every second; if
there is less than 512 bits of entropy available, it will feed the pool
with 256 random bytes. The program will quit upon receiving a `^C`
signal.


Scdtotp - Generate time-based OTP from an OpenPGP smartcard
-----------------------------------------------------------
Scdtotp uses an OpenPGP smartcard as a poor man’s one-time password
generator token. It generates time-based one-time password (TOTP) as per
[RFC 6238](http://tools.ietf.org/html/rfc6238), based on a key it
expects to find in the private data object of the inserted OpenPGP
smartcard.

> Contrary to a true password generator token, the key cannot remain
> only on the smartcard, it has to be sent to the computer so that
> scdtotp can derive the password from it. Thus it cannot provide the
> same level of security.

The key must be stored as an `otpauth://` URI as specified in [Google
Authenticator’s wiki](https://code.google.com/p/google-authenticator/wiki/KeyUriFormat),
e.g.:

```
otpauth://totp/alice@example.org?secret=KIMEFUAW4SRW
```

where the _secret_ parameter is the Base32-encoded key.  This format
allows to specify also the non-secret parameters of the TOTP algorithm:

- the HMAC algorithm to use: `&algorithm=mac`, where _mac_ can be `sha1`
  (default), `sha256`, or `sha512`;
- the time period: `&period=N`, where _N_ is expressed in seconds (30
  seconds by default);
- the number of digits to output: `&digits=N` (defaults to 6).

> The (undocumented) `privatedo N` command of the GnuPG’s card editor
> may be used to store the URI into the Nth private DO of the OpenPGP
> smartcard.

Once the URI is on the card and the card is inserted in the card reader,
simply calling _scdtotp_ will print the one-time password for the
current time window on standard output.


Copying
-------
Scdtools is distributed under the terms of the GNU General Public
License, version 3 or higher. The full license is included in the
[COPYING file](COPYING) of the source distribution.


Homepage and repository
-----------------------
The project is located at <https://incenp.org/dvlpt/scdtools.html>.
The latest source code is available in a Git repository at
<https://git.incenp.org/damien/scdtools>.
