/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.builders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.graph.OnlyTransitivePredicate;

public class StartIniBuilder
implements BaseBuilder.Config {
    private final BaseHome baseHome;
    private final Path startIni;
    private Set<String> modulesPresent = new HashSet<String>();
    private Set<String> propsPresent = new HashSet<String>();

    public StartIniBuilder(BaseBuilder baseBuilder) throws IOException {
        this.baseHome = baseBuilder.getBaseHome();
        this.startIni = this.baseHome.getBasePath("start.ini");
        if (Files.exists(this.startIni, new LinkOption[0])) {
            this.parseIni();
        }
    }

    private void parseIni() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.startIni, StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("--module=")) {
                    List<String> moduleNames = Props.getValues(line);
                    this.modulesPresent.addAll(moduleNames);
                    continue;
                }
                if (line.startsWith("-") || !line.contains("=")) continue;
                String key = line.substring(0, line.indexOf(61));
                this.propsPresent.add(key);
            }
        }
    }

    @Override
    public boolean addModule(Module module) throws IOException {
        if (this.modulesPresent.contains(module.getName())) {
            StartLog.info("%-15s already initialised in %s", module.getName(), this.baseHome.toShortForm(this.startIni));
            return false;
        }
        if (module.isDynamic()) {
            if (module.hasIniTemplate()) {
                StartLog.warn("%-15s not adding [ini-template] from dynamic module", module.getName());
            }
            return false;
        }
        String mode = "";
        boolean isTransitive = module.matches(OnlyTransitivePredicate.INSTANCE);
        if (isTransitive) {
            mode = "(transitively) ";
        }
        if (module.hasIniTemplate() || !isTransitive) {
            StartLog.info("%-15s initialised %sin %s", module.getName(), mode, this.baseHome.toShortForm(this.startIni));
            try (BufferedWriter writer = Files.newBufferedWriter(this.startIni, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
                this.writeModuleSection(writer, module);
            }
            return true;
        }
        return false;
    }

    protected void writeModuleSection(BufferedWriter writer, Module module) {
        PrintWriter out = new PrintWriter(writer);
        out.println("# --------------------------------------- ");
        out.println("# Module: " + module.getName());
        out.println("--module=" + module.getName());
        out.println();
        for (String line : module.getIniTemplate()) {
            out.println(line);
        }
        out.println();
        out.flush();
    }
}

