/* Reads events from Creative RM900 and runs scripts
 * (replacement for Creative Remote Center)
 * Ben Lynn
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//for printf() et al.
#include <stdio.h>

//for getenv()
#include <stdlib.h>

//for write()
#include <unistd.h>

//for strcat()
#include <string.h>

//for open()
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

//for signal()
#include <signal.h>

//for wait()
#include <sys/wait.h>

#include "button.h"
#include "handler.h"

static char defaultrcfile[] = "rcrc";

static char *dirstr = NULL;
static char* action_file;
static char* initial_action;

static void sig_chld(int signo)
{
    pid_t pid;
    int stat;

    while ((pid = waitpid(-1, &stat, WNOHANG)) > 0) {
	printf("child %d terminated\n", pid);
    }
    return;
}

char *clonestr(char *src)
{
    char *res = (char *) malloc(sizeof(char) * strlen(src) + 1);
    strcpy(res, src);

    return res;
}

char *clonepath(char *dir, char *src)
{
    char *dst;

    if (src[0] != '/' && dir) {
	dst = (char *) malloc(strlen(dir) + strlen(src) + 1);
	if (!dst) {
	    return NULL;
	}
	strcpy(dst, dir);
	strcat(dst, src);
    } else {
	dst = (char *) malloc(strlen(src) + 1);
	if (!dst) {
	    return NULL;
	}
	strcpy(dst, src);
    }
    return dst;
}

static void do_pipe(char *pipefile, char *button)
{
    char s[100];
    int pipefd;

    pipefd = open(pipefile, O_WRONLY | O_NONBLOCK);
    if (pipefd == -1) {
	perror("open");
	return;
    }

    sprintf(s, "%s\n", button);
    write(pipefd, s, strlen(s));
}

static void do_dir(char *dir, char *button)
{
    char name[1024];
    struct stat buf;

    strcpy(name, dir);
    strcat(name, "/");
    strcat(name, button);
    
    if (stat(name, &buf)) {
	return;
    }

    if (!fork()) {
	execl(name, name, NULL);
	perror("exec");
    }
}

static void do_arg(char *file, char *button)
{
    struct stat buf;

    if (stat(file, &buf)) {
	return;
    }

    if (!fork()) {
	execl(file, file, button, NULL);
	perror("exec");
    }
}

void send_string(char *bname)
{
    FILE *fp;
    char buf[101];
    char arg[101];
    char *s;

    fp = fopen(action_file, "r");
    if (!fp) {
	fprintf(stderr, "error reading action file\n");
	return;
    }
    //TODO: buffer overflow?
    fscanf(fp, "%s", buf);
    if (feof(fp)) return;
    fscanf(fp, "%s", arg);
    if (feof(fp)) return;
    fclose(fp);

    s = clonepath(dirstr, arg);
    printf("current action: %s %s\n", buf, s);
    if (!strcmp(buf, "script")) {
	do_arg(s, bname);
    }
    if (!strcmp(buf, "directory")) {
	do_dir(s, bname);
    }
    if (!strcmp(buf, "pipe")) {
	do_pipe(s, bname);
    }
    free(s);
}

void handle_number(int n) {
    char s[100];

    sprintf(s, "%d", n);

    send_string(s);
}

void handle_button(int button, int speaker_flag)
{
    char bname[100];

    if (speaker_flag) {
	strcpy(bname, "speaker");
	strcat(bname, button_name[button]);
    } else {
	strcpy(bname, button_name[button]);
    }

    send_string(bname);
}

void init_handler()
{
    char *s;
    char *rcfile;
    FILE *fp;
    char buf[101];
    char arg[101];

    int i;

    s = getenv("HOME");
    if (s) {
	dirstr = (char *) malloc(strlen(s) + 101);
	if (!dirstr) {
	    perror("malloc");
	    exit(1);
	}
	strcpy(dirstr, s);
	strcat(dirstr, "/.rcenter/");
	rcfile = (char *) malloc(strlen(dirstr) + 101);
	if (!rcfile) {
	    perror("malloc");
	    exit(1);
	}
	strcpy(rcfile, dirstr);
	strcat(rcfile, defaultrcfile);
    } else {
	rcfile = defaultrcfile;
    }

    fp = fopen(rcfile, "r");
    if (!fp) {
	fprintf(stderr, "Can't open config file: %s\n", rcfile);
	exit(1);
    }

    i = 0;
    for(;;) {
	int l;
	//TODO: buffer overflow?
	fscanf(fp, "%s ", buf);
	if (feof(fp)) break;
	fgets(arg, 100, fp);
	if (feof(fp)) break;
	
	l = strlen(arg);
	if (l && arg[l - 1] == '\n') {
	    arg[l - 1] = 0;
	}

	if (!strcmp(buf, "initial_action")) {
	    initial_action = clonestr(arg);
	}

	if (!strcmp(buf, "action_file")) {
	    if (arg[0] == '/') {
		action_file = clonestr(arg);
	    } else {
		action_file = clonepath(dirstr, arg);
	    }
	}
    }
    fclose(fp);

    if (!action_file) {
	fprintf(stderr, "no action file specified\n");
	exit(1);
    }
    if (!initial_action) {
	fprintf(stderr, "no initial action\n");
	exit(1);
    }

    fp = fopen(action_file, "w");
    if (!fp) {
	fprintf(stderr, "Can't open action file: %s\n", action_file);
	exit(1);
    }
    fprintf(fp, "%s\n", initial_action);
    fclose(fp);

    signal(SIGCHLD, sig_chld);
}
