/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_QUERY_LOGINS_H__
#define __SBP2_QUERY_LOGINS_H__


#include <glib.h>

#include <libsbp2/sbp2pointer.h>


typedef struct _SBP2QueryLoginsORB SBP2QueryLoginsORB;
typedef struct _SBP2QueryLoginsResponse SBP2QueryLoginsResponse;

struct _SBP2QueryLoginsORB
{
  guint32     reserved1;
  guint32     reserved2;
  SBP2Pointer query_resp;
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint       notify       : 1;
  guint       req_fmt      : 2;
  guint       reserved3    : 9;
  guint       function     : 4;
  guint       lun          : 16;
  guint       reserved4    : 16;
  guint       resp_length  : 16;
#else
  guint       lun          : 16;
  guint       function     : 4;
  guint       reserved3    : 9;
  guint       req_fmt      : 2;
  guint       notify       : 1;
  guint       resp_length  : 16;
  guint       reserved4    : 16;
#endif
  SBP2Pointer status_FIFO;
};

struct _SBP2QueryLoginsResponse
{
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint length     : 16;
  guint max_logins : 16;
#else
  guint max_logins : 16;
  guint length     : 16;
#endif

  /* TODO: Logged in initiator listing here, ignored for now */
};


#endif /* __SBP2_QUERY_LOGINS_H__ */
