/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.protocol;

import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.MultiformatMessageString;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorReference;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorRelationship;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.RunAutomationDetails;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.net.URI;
import java.util.UUID;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.protocol.OpenInIdeProblemParameters;
import org.jetbrains.qodana.protocol.SingleMarkerReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptorBuilder;
import org.jetbrains.qodana.report.ReportResult;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.ValidatedSarif;
import org.jetbrains.qodana.staticAnalysis.sarif.QodanaSeverity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/ReportDescriptorBuilder;", "Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lorg/jetbrains/qodana/protocol/OpenInIdeProblemParameters;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/protocol/OpenInIdeProblemParameters;)V", "createReportDescriptor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "constructSingleMarkerReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSingleMarkerReportDescriptorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleMarkerReportDescriptorBuilder.kt\norg/jetbrains/qodana/protocol/SingleMarkerReportDescriptorBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class SingleMarkerReportDescriptorBuilder
implements ReportDescriptorBuilder<SingleMarkerReportDescriptor> {
    @NotNull
    private final Project project;
    @NotNull
    private final OpenInIdeProblemParameters parameters;

    public SingleMarkerReportDescriptorBuilder(@NotNull Project project, @NotNull OpenInIdeProblemParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.project = project;
        this.parameters = parameters;
    }

    @Override
    @Nullable
    public Object createReportDescriptor(@NotNull Continuation<? super SingleMarkerReportDescriptor> $completion) {
        SarifReport report2 = this.constructSingleMarkerReport();
        ReportResult<ValidatedSarif, ReportValidator.ValidatorError> validatedReportResult = ReportValidator.INSTANCE.validateReport(report2);
        if (validatedReportResult instanceof ReportResult.Fail) {
            ((ReportValidator.ValidatorError)((ReportResult.Fail)validatedReportResult).getError()).throwException();
            throw new KotlinNothingValueException();
        }
        if (!(validatedReportResult instanceof ReportResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        ValidatedSarif validatedReport = (ValidatedSarif)((ReportResult.Success)validatedReportResult).getLoadedSarifReport();
        return new SingleMarkerReportDescriptor(this.project, validatedReport, this.parameters.getPathText(), this.parameters.getRevisionId(), this.parameters.getOrigin(), this.parameters.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    private final SarifReport constructSingleMarkerReport() {
        void $this$constructSingleMarkerReport_u24lambda_u240;
        PropertyBag propertyBag;
        String string;
        String inspectionId;
        RunAutomationDetails automationDetails = new RunAutomationDetails().withGuid(UUID.randomUUID().toString()).withId(this.parameters.getPathText() + " - " + this.parameters.getMessage());
        VersionControlDetails vcsDetails = this.parameters.getRevisionId() != null ? new VersionControlDetails(URI.create(this.parameters.getOrigin())).withRevisionId(this.parameters.getRevisionId()) : null;
        String string2 = this.parameters.getInspectionId();
        if (string2 == null) {
            string2 = inspectionId = "";
        }
        if ((string = this.parameters.getInspectionCategory()) == null) {
            string = "";
        }
        String category = string;
        PropertyBag propertyBag2 = propertyBag = new PropertyBag();
        Result result2 = new Result(new Message().withText(this.parameters.getMessage())).withLocations(CollectionsKt.listOf((Object)new Location().withPhysicalLocation(new PhysicalLocation().withArtifactLocation(new ArtifactLocation().withUri(this.parameters.getPath()).withUriBaseId("SRCROOT")).withRegion(new Region().withStartColumn(this.parameters.getColumn()).withStartLine(this.parameters.getLine()).withCharLength(this.parameters.getMarkerLength()))))).withRuleId(inspectionId);
        boolean bl = false;
        QodanaSeverity qodanaSeverity = this.parameters.getSeverity();
        $this$constructSingleMarkerReport_u24lambda_u240.put("qodanaSeverity", (Object)(qodanaSeverity != null ? qodanaSeverity.toString() : null));
        Result result3 = result2.withProperties(propertyBag);
        ReportingDescriptor reportingDescriptor = new ReportingDescriptor(inspectionId);
        String string3 = this.parameters.getInspectionName();
        if (string3 == null) {
            string3 = "";
        }
        ReportingDescriptor rule = reportingDescriptor.withShortDescription(new MultiformatMessageString(string3)).withRelationships(SetsKt.setOf((Object)new ReportingDescriptorRelationship(new ReportingDescriptorReference().withId(category))));
        ToolComponent driver = new ToolComponent("single-marker-tool").withTaxa(CollectionsKt.listOf((Object)new ReportingDescriptor(category).withName(category)));
        Tool tool = new Tool(driver).withExtensions(SetsKt.setOf((Object)new ToolComponent("").withRules(CollectionsKt.listOf((Object)rule))));
        Run run2 = new Run(tool).withAutomationDetails(automationDetails).withVersionControlProvenance(SetsKt.setOf((Object)vcsDetails)).withResults(CollectionsKt.listOf((Object)result3));
        return new SarifReport(SarifReport.Version._2_1_0, CollectionsKt.listOf((Object)run2));
    }
}

