#ifndef AUTH_H
# define AUTH_H

#include <sys/types.h>
#include "bool.h"

typedef struct {
	char *data;
	size_t len;
} mmap_area;

struct account {
	mmap_area user;
	char *lock; /* '!'==locked, ':'==unlocked */
	mmap_area crypass;
};

extern bool auth_getaccount(const char *user, mmap_area authfile, 
		struct account *ac);
extern mmap_area auth_getline(struct account *ac, mmap_area start);
extern bool auth_checkpass(const char *plainpw, mmap_area crypass);
extern bool invalid_authfile(mmap_area authfile);
#if 1
extern bool was_a_username(char *username);
#endif
bool is_a_username(char firstchar);
#endif
