/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_RTSUnit
#define GUARD_RTSUnit

#include "RTSUnit_Base.h"
#include "GenericHandle.h"

class RTSUnit {
public:
	RTSUnit(int iMySide, int iMyGroup, UnitType iType, const string& iName);
	RTSUnit(int iMySide, int iMyGroup, UnitType iType, const string& iName, CapShipType iCSType);

	static UnitType WhatUTIsThis(int nSide, string& filename);

	void SetPos(float ix, float iy) {hUnit->SetPos(ix, iy);}

	void SelectSmallTargets() {if (hUnit->alive) hUnit->SelectSmallTargets();}
	void SelectSmallTargets(AICommands& theCommands) {if (hUnit->alive) hUnit->SelectSmallTargets(theCommands);}

	void Move(float distx, float disty) {if (hUnit->alive) hUnit->Move(distx, disty);}
	void AddExtraMoveFrames() {if (hUnit->alive) hUnit->AddExtraMoveFrames();}
	void Fire(AICommands& theCommands) {if (hUnit->alive) hUnit->Fire(theCommands);}

	void BeenHit(int power) {if (hUnit->alive) hUnit->BeenHit(power);}

	void Upkeep() {if (hUnit->alive) hUnit->Upkeep(); else hUnit->DeadUpkeep();}

	void DrawSelf() {hUnit->DrawSelf();}
	void DrawSelfPixels() {hUnit->DrawSelfPixels();}
	void DrawUnitPic(int x, int y) {hUnit->DrawUnitPic(x, y);}

	int GetPointsValue() const {return hUnit->GetPointsValue();}
	int GetMaxPoints() const {return hUnit->GetMaxPoints();}
	string GetName() const {return hUnit->name;}
	string GetRealPictureName() const;
	UnitType GetType() const {return hUnit->myType;}
	CapShipType GetCSType() const {return hUnit->myCSType;}

	int GetSmallNumber() const {return hUnit->smallNumber;}

	int GetHealth() const {return hUnit->shieldCurrent + hUnit->armourCurrent;}
	int GetShield() const {return hUnit->shieldCurrent;}
	int GetArmour() const {return hUnit->armourCurrent;}
	int GetMaxHealth() const {return hUnit->shieldMax + hUnit->armourMax;}
	int GetMaxShield() const {return hUnit->shieldMax;}
	int GetMaxArmour() const {return hUnit->armourMax;}
	
	void GetShAndAr(int& giveShieldC, int& giveShieldM, int& giveShieldR, int& giveArmourC, int& giveArmourM)     const {
		giveShieldC = hUnit->shieldCurrent;
		giveShieldM = hUnit->shieldMax;
		giveShieldR = hUnit->shieldRecharge;
		giveArmourC = hUnit->armourCurrent;
		giveArmourM = hUnit->armourMax;
	}

	float GetSpeed() const {return hUnit->speed;}
	WeaponType GetSmallType() const {return hUnit->smallType;}
	WeaponType GetBigType() const {return hUnit->bigType;}
	int GetBigAmmo() const {return hUnit->bigAmmo;}

	void GetDimensions(int& giveWidth, int& giveHeight) const {giveWidth = hUnit->width; giveHeight = hUnit->height;}
	CoordsInt GetCenter() const {return hUnit->GetCenter();}
	CoordsInt GetWeakSpot() const {return hUnit->GetWeakSpot();}

	string GetEngineName() const {return hUnit->engineName;}
	string GetShieldName() const {return hUnit->shieldName;}
	string GetArmourName() const {return hUnit->armourName;}

	int GetCapacity() const {return hUnit->GetCapacity();}
	int GetFrCapacity() const {return hUnit->GetFrCapacity();}

	void GetWeapCoords(vector<CoordsInt>& giveSmall, CoordsInt& giveBig) const {return hUnit->GetWeapCoords(giveSmall, giveBig);}

	int GetAlive() const {return hUnit->alive;}

	//Change:
	void ChangeUnitPic(const string& newPic) {hUnit->ChangeUnitPic(newPic);}
	void ChangeSmallType(WeaponType newType) {hUnit->ChangeSmallType(newType);}
	void ChangeBigType(WeaponType newType) {hUnit->ChangeBigType(newType);}
	void ChangeEngine(const string& newType) {hUnit->ChangeEngine(newType);}
	void ChangeArmour(const string& newStat) {hUnit->ChangeArmour(newStat);}
	void ChangeShield(const string& newStat) {hUnit->ChangeShield(newStat);}
	void ChangeCSType(CapShipType newType) {hUnit->ChangeCSType(newType);}

	void ChangeMySide(int newMySide) {hUnit->mySide = newMySide;}
	void ChangeGroupNumber(int newNumber) {hUnit->myGroup = newNumber;}

protected:
	GenericHandle<RTSUnit_Base> hUnit;
};

#endif


