// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Shared

module Archive =
    open System
    open System.IO

    open SimpleLog.SimpleLog

    open Gdmt.Shared

    let CreateArchive (inputPath: string) (outputPath: string) : unit =
        if File.Exists outputPath then
            File.Delete outputPath

        let numThreadsReal = Environment.ProcessorCount
        let numThreadsSafe = if numThreadsReal > 2 then numThreadsReal - 2 else 1

        let args = [ "tar"; "--auto-compress"; "--create"; "--file"; outputPath; inputPath ]

        let env = [ ("XZ_OPT", $"-T{numThreadsSafe}") ]

        LogMessage Debug $"Creating archive from:  {inputPath}"
        LogMessage Debug $"Creating archive file:  {outputPath}"

        ExecProcess(args, env).Run().Check()
