#!/usr/bin/env -S pwsh -NoLogo -NoProfile -NonInteractive

# Copyright 2023-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

$ErrorActionPreference = "Stop"
Set-StrictMode -Version Latest

$admin = "${PSScriptRoot}"
$source = "${admin}/../"

Set-Location $source

$includedFileExts = @("*.fs", "*.fsi", "*.fsx")
$filePaths = Get-ChildItem -File -Include $includedFileExts -Path . -Recurse
| Where-Object { $_.ResolvedTarget -notlike "*/.cache/*" }

foreach ($filePath in $filePaths) {
    & "$PSScriptRoot/dotnet_wrapper.sh" tool run `
        fantomas --verbosity detailed $filePath

    if ($LASTEXITCODE -ne 0) {
        throw "dotnet_wrapper.sh failed"
    }
}
