#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXMetaClass.h"
#include "FXTextCodec.h"
#include "FX88592Codec.h"

namespace FX {

FXIMPLEMENT(FX88592Codec,FXTextCodec,nullptr,0)


//// Created by codec tool on 03/24/2005 from: 8859-2.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,  143,
   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
   160,  260,  728,  321,  164,  317,  346,  167,  168,  352,  350,  356,  377,  173,  381,  379,
   176,  261,  731,  322,  180,  318,  347,  711,  184,  353,  351,  357,  378,  733,  382,  380,
   340,  193,  194,  258,  196,  313,  262,  199,  268,  201,  280,  203,  282,  205,  206,  270,
   272,  323,  327,  211,  212,  336,  214,  215,  344,  366,  218,  368,  220,  221,  354,  223,
   341,  225,  226,  259,  228,  314,  263,  231,  269,  233,  281,  235,  283,  237,  238,  271,
   273,  324,  328,  243,  244,  337,  246,  247,  345,  367,  250,  369,  252,  253,  355,  729,
  };


static const unsigned char reverse_plane[17]={
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  };

static const unsigned char reverse_pages[65]={
  0,  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46,
  };

static const unsigned short reverse_block[110]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 191, 206, 222, 237,
  251, 267, 279, 286, 301, 317, 333, 349, 279, 279, 279, 279, 279, 279, 279, 279,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 364, 372, 279, 279,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  };

static const unsigned char reverse_data[388]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,  143,
   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
   160,  26,   26,   26,   164,  26,   26,   167,  168,  26,   26,   26,   26,   173,  26,   26,
   176,  26,   26,   26,   180,  26,   26,   26,   184,  26,   26,   26,   26,   26,   26,   26,
   193,  194,  26,   196,  26,   26,   199,  26,   201,  26,   203,  26,   205,  206,  26,   26,
   26,   211,  212,  26,   214,  215,  26,   26,   218,  26,   220,  221,  26,   223,  26,   225,
   226,  26,   228,  26,   26,   231,  26,   233,  26,   235,  26,   237,  238,  26,   26,   26,
   243,  244,  26,   246,  247,  26,   26,   250,  26,   252,  253,  26,   26,   195,  227,  161,
   177,  198,  230,  26,   26,   26,   26,   200,  232,  207,  239,  208,  240,  26,   26,   26,
   26,   26,   26,   202,  234,  204,  236,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   197,  229,  26,   26,   165,  181,  26,   163,  179,
   209,  241,  26,   26,   210,  242,  26,   26,   26,   26,   26,   26,   26,   213,  245,  26,
   26,   192,  224,  26,   26,   216,  248,  166,  182,  26,   26,   170,  186,  169,  185,  222,
   254,  171,  187,  26,   26,   26,   26,   26,   26,   26,   26,   217,  249,  219,  251,  26,
   26,   26,   26,   26,   26,   26,   172,  188,  175,  191,  174,  190,  26,   26,   26,   26,
   26,   26,   26,   183,  26,   26,   26,   26,   26,   26,   26,   26,   162,  255,  26,   178,
   26,   189,  26,   26,
  };


FXint FX88592Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FX88592Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }


FXint FX88592Codec::mibEnum() const {
  return 5;
  }


const FXchar* FX88592Codec::name() const {
  return "ISO-8859-2";
  }


const FXchar* FX88592Codec::mimeName() const {
  return "ISO-8859-2";
  }


const FXchar* const* FX88592Codec::aliases() const {
  static const FXchar *const list[]={"iso8859-2","ISO-8859-2","ISO_8859-2","latin2","iso-ir-101","l2","csISOLatin2",nullptr};
  return list;
  }

}
