/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.gradle.api.NonNullApi;
import org.gradle.util.internal.EncryptionAlgorithm;

@NonNullApi
public class SupportedEncryptionAlgorithm {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final EncryptionAlgorithm AES_GCM_NO_PADDING = new DefaultEncryptionAlgorithm<GCMParameterSpec>("AES/GCM/NoPadding", RANDOM, new GcmAlgorithmParameters(128));
    private static final EncryptionAlgorithm AES_CTR_NO_PADDING = new DefaultEncryptionAlgorithm<IvParameterSpec>("AES/CTR/NoPadding", RANDOM, new IvOnlyAlgorithmParameters());

    public static EncryptionAlgorithm getDefault() {
        return AES_CTR_NO_PADDING;
    }

    public static Set<EncryptionAlgorithm> getAll() {
        return ImmutableSet.of((Object)AES_GCM_NO_PADDING, (Object)AES_CTR_NO_PADDING);
    }

    private static byte[] generateIv(int size, SecureRandom random) {
        byte[] iv = new byte[size];
        random.nextBytes(iv);
        return iv;
    }

    private static byte[] readNBytes(InputStream inputStream, int size) throws IOException {
        byte[] buf = new byte[size];
        ByteStreams.readFully((InputStream)inputStream, (byte[])buf);
        return buf;
    }

    private static class IvOnlyAlgorithmParameters
    implements AlgorithmParameters<IvParameterSpec> {
        private IvOnlyAlgorithmParameters() {
        }

        @Override
        public IvParameterSpec read(InputStream inputStream, int blockSize) throws IOException {
            byte[] iv = SupportedEncryptionAlgorithm.readNBytes(inputStream, blockSize);
            return new IvParameterSpec(iv);
        }

        @Override
        public IvParameterSpec write(OutputStream outputStream, SecureRandom random, int blockSize) throws IOException {
            byte[] iv = SupportedEncryptionAlgorithm.generateIv(blockSize, random);
            outputStream.write(iv);
            return new IvParameterSpec(iv);
        }
    }

    private static class GcmAlgorithmParameters
    implements AlgorithmParameters<GCMParameterSpec> {
        private static final int IV_LENGTH_BYTES = 12;
        private final int tagLengthBits;

        public GcmAlgorithmParameters(int tagLengthBits) {
            this.tagLengthBits = tagLengthBits;
        }

        @Override
        public GCMParameterSpec read(InputStream inputStream, int blockSize) throws IOException {
            byte[] iv = SupportedEncryptionAlgorithm.readNBytes(inputStream, 12);
            return new GCMParameterSpec(this.tagLengthBits, iv);
        }

        @Override
        public GCMParameterSpec write(OutputStream outputStream, SecureRandom random, int blockSize) throws IOException {
            byte[] iv = SupportedEncryptionAlgorithm.generateIv(12, random);
            outputStream.write(iv);
            return new GCMParameterSpec(this.tagLengthBits, iv);
        }
    }

    static interface AlgorithmParameters<P extends AlgorithmParameterSpec> {
        public P read(InputStream var1, int var2) throws IOException;

        public P write(OutputStream var1, SecureRandom var2, int var3) throws IOException;
    }

    private static class DefaultEncryptionAlgorithm<P extends AlgorithmParameterSpec>
    implements EncryptionAlgorithm {
        private final String transformation;
        private final SecureRandom random;
        private final AlgorithmParameters<P> parameters;

        public DefaultEncryptionAlgorithm(String transformation, SecureRandom random, AlgorithmParameters<P> parameters) {
            this.transformation = transformation;
            this.random = random;
            this.parameters = parameters;
        }

        public final InputStream decryptedStream(InputStream inputStream, SecretKey key) throws GeneralSecurityException, IOException {
            Cipher cipher = Cipher.getInstance(this.transformation);
            int blockSize = cipher.getBlockSize();
            P params = this.parameters.read(inputStream, blockSize);
            cipher.init(2, (Key)key, (AlgorithmParameterSpec)params);
            return new CipherInputStream(inputStream, cipher);
        }

        public final OutputStream encryptedStream(OutputStream outputStream, SecretKey key) throws GeneralSecurityException, IOException {
            Cipher cipher = Cipher.getInstance(this.transformation);
            int blockSize = cipher.getBlockSize();
            P params = this.parameters.write(outputStream, this.random, blockSize);
            cipher.init(1, (Key)key, (AlgorithmParameterSpec)params);
            return new CipherOutputStream(outputStream, cipher);
        }

        public final String getTransformation() {
            return this.transformation;
        }

        public final String getAlgorithm() {
            return this.transformation.substring(0, this.transformation.indexOf(47));
        }
    }
}

