#!/bin/sh
#   
# Title: cdcat installation program
# Version: 0.2
# Author: LittleDragon <littledragon@altern.org>
#       
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#           
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#           

# Parameters.

if [ `echo $1|grep "^--prefix="|wc -l|xargs` -gt 0 ]; then
	PREFIX=`echo $1|sed 's/^--prefix=\(.*\)$/\1/'`
else
	PREFIX="/usr/local"
fi

MAN_PREFIX="/usr/share/man"

if [ `echo $1|grep "^--help"|wc -l|xargs` -gt 0 ]; then
	echo "
Options:

  --help              Show this help screen
  --prefix=PREFIX     Set an alternative prefix for installing the files.
                      Default: $PREFIX
  --man_prefix=PREFIX Set an alternative prefix for installing the manual file.
                      Default: $MAN_PREFIX
"
	exit 1
fi

# Creating directory if it doesn't exist.

mkdir -p $PREFIX/bin

# Verifying for previous installation.

if [ -e $PREFIX/bin/cdcat -o -h $PREFIX/bin/cdcat ]; then
	rm -f $PREFIX/bin/cdcat
fi

# Installing files.

cp -f src/cdcat.pl $PREFIX/bin/cdcat
cp -f doc/man/cdcat.1.gz $MAN_PREFIX/man1/cdcat.1.gz
chmod 755 $PREFIX/bin/cdcat

# Displaying final messages.

if [ -x $PREFIX/bin/cdcat ]; then
	echo Installation successful.
fi
