/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.xmind.core.command.Command;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.arguments.ArrayMapper;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IIdentifier;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.command.remote.IRemoteCommandServiceListener;
import org.xmind.core.command.remote.RemoteCommandJob;
import org.xmind.core.internal.sharing.Base64;
import org.xmind.core.internal.sharing.ContactManager;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.internal.sharing.LocalSharedLibrary;
import org.xmind.core.internal.sharing.LocalSharedMap;
import org.xmind.core.internal.sharing.Messages;
import org.xmind.core.internal.sharing.RemoteSharedLibrary;
import org.xmind.core.internal.sharing.RemoteSharedMap;
import org.xmind.core.sharing.IContactManager;
import org.xmind.core.sharing.ILocalSharedLibrary;
import org.xmind.core.sharing.ILocalSharedMap;
import org.xmind.core.sharing.IRemoteSharedLibrary;
import org.xmind.core.sharing.ISharedLibrary;
import org.xmind.core.sharing.ISharedMap;
import org.xmind.core.sharing.ISharingListener;
import org.xmind.core.sharing.ISharingService;
import org.xmind.core.sharing.SharingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalNetworkSharingService
implements ISharingService,
IRemoteCommandServiceListener {
    private static final String PROP_STATUS = "org.xmind.core.sharing.localnetwork.service.status";
    private static final String[] STATUS_VALUES = new String[]{"INACTIVE", "ACTIVATING", "ACTIVE", "DEACTIVATING"};
    private static final Comparator<IRemoteSharedLibrary> RemoteLibraryComparator = new Comparator<IRemoteSharedLibrary>(){

        @Override
        public int compare(IRemoteSharedLibrary r1, IRemoteSharedLibrary r2) {
            return r1.getName().compareTo(r2.getName());
        }
    };
    private int status = 0;
    private ICommandServiceDomain domain;
    private LocalSharedLibrary localLibrary = null;
    private ContactManager contactManager = null;
    private Map<IRemoteCommandService, IRemoteSharedLibrary> remoteLibraries = new HashMap<IRemoteCommandService, IRemoteSharedLibrary>();
    private ListenerList listeners = new ListenerList();
    private boolean disposed = false;
    private Object lock = new Object();
    private List<Job> jobs = new ArrayList<Job>();

    LocalNetworkSharingService() {
        System.setProperty(PROP_STATUS, STATUS_VALUES[0]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ICommandServiceDomain.class) {
            return this.domain;
        }
        if (adapter == ISchedulingRule.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus activate(IProgressMonitor monitor) {
        ICommandServiceDomain theDomain;
        Object object = this.lock;
        synchronized (object) {
            if (this.status != 0) {
                return Status.CANCEL_STATUS;
            }
            this.changeStatus(1);
        }
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.LocalNetworkSharingService_ConnectionLocalNetworkSharing);
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.domain == null) {
                this.domain = LocalNetworkSharing.getDefault().getCommandServiceDomainManager().getCommandServiceDomain("org.xmind.core.command.remote.domains.lan");
            }
            theDomain = this.domain;
        }
        if (theDomain == null) {
            object2 = this.lock;
            synchronized (object2) {
                this.changeStatus(0);
            }
            return new Status(4, "org.xmind.core.sharing.localnetwork", 23330, "No LAN remote domain service available.", null);
        }
        theDomain.getRemoteCommandServiceDiscoverer().addRemoteCommandServiceListener((IRemoteCommandServiceListener)this);
        IStatus connected = theDomain.getDirector().connect((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        if (connected != null && !connected.isOK()) {
            theDomain.getRemoteCommandServiceDiscoverer().removeRemoteCommandServiceListener((IRemoteCommandServiceListener)this);
            Object object3 = this.lock;
            synchronized (object3) {
                this.changeStatus(3);
            }
            theDomain.getDirector().disconnect((IProgressMonitor)new NullProgressMonitor());
            object3 = this.lock;
            synchronized (object3) {
                this.changeStatus(0);
            }
            return connected;
        }
        Object object4 = this.lock;
        synchronized (object4) {
            this.changeStatus(2);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus deactivate(IProgressMonitor monitor) {
        ICommandServiceDomain theDomain;
        Object object = this.lock;
        synchronized (object) {
            if (this.status != 2) {
                return Status.CANCEL_STATUS;
            }
            this.changeStatus(3);
        }
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.LocalNetworkSharingService_DisconnectionLocalNetworkSharing);
        Object object2 = this.lock;
        synchronized (object2) {
            theDomain = this.domain;
            this.domain = null;
        }
        IStatus result = null;
        if (theDomain != null) {
            this.clearJobs();
            IStatus disconnected = theDomain.getDirector().disconnect((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            if (disconnected != null && !disconnected.isOK()) {
                result = disconnected;
            }
            theDomain.getRemoteCommandServiceDiscoverer().removeRemoteCommandServiceListener((IRemoteCommandServiceListener)this);
        }
        Object object3 = this.lock;
        synchronized (object3) {
            this.changeStatus(0);
        }
        monitor.done();
        if (result != null) {
            return result;
        }
        return Status.OK_STATUS;
    }

    private void changeStatus(int newStatus) {
        int oldStatus = this.status;
        this.status = newStatus;
        System.setProperty(PROP_STATUS, STATUS_VALUES[newStatus]);
        this.fireSharingEvent(new SharingEvent(oldStatus, newStatus));
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public synchronized ILocalSharedLibrary getLocalLibrary() {
        if (this.localLibrary == null && !this.disposed) {
            this.localLibrary = new LocalSharedLibrary(this);
        }
        return this.localLibrary;
    }

    @Override
    public synchronized IContactManager getContactManager() {
        if (this.contactManager == null && !this.disposed) {
            this.contactManager = new ContactManager(this);
        }
        return this.contactManager;
    }

    @Override
    public synchronized Collection<IRemoteSharedLibrary> getRemoteLibraries() {
        ICommandServiceDomain theDomain = this.domain;
        TreeSet<IRemoteSharedLibrary> result = new TreeSet<IRemoteSharedLibrary>(RemoteLibraryComparator);
        if (theDomain != null) {
            IRemoteCommandService[] remoteCommandServices = theDomain.getRemoteCommandServiceDiscoverer().getRemoteCommandServices();
            int i = 0;
            while (i < remoteCommandServices.length) {
                IRemoteCommandService remoteService = remoteCommandServices[i];
                IRemoteSharedLibrary library = this.remoteLibraries.get(remoteService);
                if (library != null) {
                    result.add(library);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public synchronized IRemoteSharedLibrary findRemoteLibrary(String symbolicName) {
        if (symbolicName == null) {
            return null;
        }
        ICommandServiceDomain theDomain = this.domain;
        if (theDomain == null) {
            return null;
        }
        IRemoteCommandService service = theDomain.getRemoteCommandServiceDiscoverer().findRemoteCommandService(symbolicName);
        if (service == null) {
            return null;
        }
        return this.remoteLibraries.get(service);
    }

    @Override
    public synchronized IRemoteSharedLibrary findRemoteLibraryByID(String contactID) {
        if (contactID == null || "".equals(contactID)) {
            return null;
        }
        for (IRemoteSharedLibrary remoteLibrary : this.remoteLibraries.values()) {
            String id = remoteLibrary.getContactID();
            if (!contactID.equals(id)) continue;
            return remoteLibrary;
        }
        return null;
    }

    @Override
    public IStatus refresh(IProgressMonitor monitor) {
        if (this.status != 2) {
            return Status.CANCEL_STATUS;
        }
        this.remoteLibraries.clear();
        ICommandServiceDomain theDomain = this.domain;
        if (theDomain == null) {
            return Status.CANCEL_STATUS;
        }
        return theDomain.getRemoteCommandServiceDiscoverer().refresh(monitor);
    }

    @Override
    public void addSharingListener(ISharingListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeSharingListener(ISharingListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void registerJob(Job job) {
        if (job == null) {
            return;
        }
        this.jobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                LocalNetworkSharingService.this.jobs.remove(event.getJob());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJobs() {
        Object[] theJobs;
        List<Job> list = this.jobs;
        synchronized (list) {
            theJobs = this.jobs.toArray();
            this.jobs.clear();
        }
        int i = 0;
        while (i < theJobs.length) {
            Job job = (Job)theJobs[i];
            if (job != null) {
                job.cancel();
            }
            ++i;
        }
    }

    public synchronized void dispose() {
        this.disposed = true;
        if (this.localLibrary != null) {
            this.localLibrary.dispose();
            this.localLibrary = null;
        }
        if (this.contactManager != null) {
            this.contactManager = null;
        }
        this.remoteLibraries.clear();
    }

    public void remoteCommandServiceDiscovered(IRemoteCommandService service) {
        RemoteLibraryAdder adder = new RemoteLibraryAdder(service);
        adder.setUser(false);
        adder.setSystem(true);
        adder.setRule(this);
        this.registerJob((Job)adder);
        adder.schedule();
    }

    public void remoteCommandServiceDropped(IRemoteCommandService service) {
        this.removeRemoteLibraryByCommandService(service);
    }

    private synchronized void addRemoteLibrary(RemoteSharedLibrary remoteLibrary) {
        this.removeRemoteLibraryByCommandService(remoteLibrary.getRemoteCommandService());
        this.remoteLibraries.put(remoteLibrary.getRemoteCommandService(), remoteLibrary);
        this.fireSharingEvent(new SharingEvent(SharingEvent.Type.LIBRARY_ADDED, remoteLibrary));
    }

    private synchronized void removeRemoteLibraryByCommandService(IRemoteCommandService service) {
        ISharedLibrary remoteLibrary;
        while ((remoteLibrary = (ISharedLibrary)this.remoteLibraries.get(service)) != null) {
            this.removeRemoteLibrary(service, remoteLibrary);
        }
    }

    private synchronized void removeRemoteLibrary(IRemoteCommandService service, ISharedLibrary remoteLibrary) {
        this.remoteLibraries.remove(service);
        this.fireSharingEvent(new SharingEvent(SharingEvent.Type.LIBRARY_REMOVED, remoteLibrary));
    }

    protected void fireSharingEvent(SharingEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISharingListener)listener).handleSharingEvent(event);
            ++n2;
        }
        this.broadcastLocalChanges(event);
    }

    private void broadcastLocalChanges(SharingEvent event) {
        if (!event.isLocal()) {
            return;
        }
        if (event.getType() == SharingEvent.Type.CONTACT_ADDED) {
            String contactID = event.getContactID();
            if (contactID == null || "".equals(contactID)) {
                return;
            }
            IRemoteSharedLibrary remoteLibrary = this.findRemoteLibraryByID(contactID);
            if (remoteLibrary != null) {
                this.startBroadcastEventJob(remoteLibrary, event);
            }
            return;
        }
        ISharedMap map = event.getMap();
        for (IRemoteSharedLibrary remoteLibrary : this.remoteLibraries.values()) {
            boolean hasAccessRight;
            String remoteID = remoteLibrary.getContactID();
            if (map != null && !(hasAccessRight = ((ILocalSharedMap)map).hasAccessRight(remoteID))) continue;
            this.startBroadcastEventJob(remoteLibrary, event);
        }
    }

    private void startBroadcastEventJob(IRemoteSharedLibrary remoteLibrary, SharingEvent event) {
        BroadcastLocalEventJob job = new BroadcastLocalEventJob((IRemoteCommandService)remoteLibrary.getAdapter(IRemoteCommandService.class), event, remoteLibrary);
        job.setRule(this);
        job.setUser(false);
        job.setSystem(true);
        this.registerJob((Job)job);
        job.schedule();
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    private class BroadcastLocalEventJob
    extends RemoteCommandJob {
        private SharingEvent event;
        private IRemoteSharedLibrary remoteLibrary;

        public BroadcastLocalEventJob(IRemoteCommandService remoteService, SharingEvent event) {
            super(Messages.LocalNetworkSharingService_BroadcastShareEvent, "org.xmind.core.sharing", remoteService);
            this.event = event;
        }

        public BroadcastLocalEventJob(IRemoteCommandService remoteService, SharingEvent event, IRemoteSharedLibrary remoteLibrary) {
            this(remoteService, event);
            this.remoteLibrary = remoteLibrary;
        }

        protected IStatus executeCommand(IProgressMonitor sendCommandMonitor, ICommand command) {
            IStatus status = super.executeCommand(sendCommandMonitor, command);
            if (status.getSeverity() == 4) {
                LocalNetworkSharing.log(status);
                status = Status.CANCEL_STATUS;
            }
            return status;
        }

        public IStatus consumeReturnValue(IProgressMonitor monitor, IStatus returnValue) {
            return returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ICommand createCommand(IProgressMonitor monitor) throws CoreException {
            ICommandServiceDomain theDomain;
            Object object = LocalNetworkSharingService.this.lock;
            synchronized (object) {
                theDomain = LocalNetworkSharingService.this.domain;
            }
            if (theDomain == null) {
                return null;
            }
            String commandName = "sharing/event/" + this.event.getType().name();
            Attributes data = new Attributes();
            ICommandServiceInfo info = theDomain.getCommandServerAdvertiser().getRegisteredInfo();
            if (info == null) {
                LocalNetworkSharing.log("Failed to broadcast local library change: Local command server is not registered or has been unregistered.", null);
                return null;
            }
            IIdentifier serverId = info.getId();
            if (serverId == null) {
                LocalNetworkSharing.log("Failed to broadcast local library change: Local command server is not identified.", null);
                return null;
            }
            data.with("remote", serverId.getName());
            if (this.event.getType() == SharingEvent.Type.CONTACT_ADDED) {
                ArrayMapper mapsWriter = new ArrayMapper(data.getRawMap(), "maps");
                ISharedMap[] iSharedMapArray = this.event.getMaps();
                int n = iSharedMapArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISharedMap map = iSharedMapArray[n2];
                    String remoteID = this.event.getContactID();
                    boolean hasAccessRight = ((ILocalSharedMap)map).hasAccessRight(remoteID);
                    if (hasAccessRight) {
                        mapsWriter.next();
                        mapsWriter.set("map", (Object)map.getID());
                        mapsWriter.set("name", (Object)map.getResourceName());
                        mapsWriter.set("thumbnail", (Object)((LocalSharedMap)map).getEncodedThumbnailData());
                        mapsWriter.set("missing", (Object)(map.isMissing() ? "true" : "false"));
                        mapsWriter.set("modified-time", (Object)String.valueOf(map.getResourceModifiedTime()));
                    }
                    ++n2;
                }
                mapsWriter.setSize();
            } else {
                ISharedMap map = this.event.getMap();
                if (map != null) {
                    data.with("map", map.getID());
                    data.with("name", map.getResourceName());
                    data.with("modified-time", String.valueOf(map.getResourceModifiedTime()));
                    if (this.remoteLibrary != null && this.remoteLibrary.getContactID() == null) {
                        String thumbnail = ((LocalSharedLibrary)LocalNetworkSharingService.this.getLocalLibrary()).getEncodedXMind2014Thumbnail();
                        data.with("thumbnail", thumbnail);
                        data.with("missing", "true");
                    } else {
                        data.with("thumbnail", ((LocalSharedMap)map).getEncodedThumbnailData());
                        data.with("missing", map.isMissing() ? "true" : "false");
                    }
                } else {
                    data.with("name", LocalNetworkSharingService.this.getLocalLibrary().getName());
                }
            }
            return new Command("sharing.core.xmind.org", commandName, data, null, null);
        }
    }

    private class RemoteLibraryAdder
    extends RemoteCommandJob {
        public static final String SYS_VERSION = "org.xmind.product.version";
        public static final String HANDSHAKE_PREFIX = "sharing/handshake";
        private IRemoteCommandService remoteService;

        public RemoteLibraryAdder(IRemoteCommandService remoteService) {
            super(Messages.LocalNetworkSharingService_ContractRemoteLibrary, "org.xmind.core.sharing", remoteService);
            this.remoteService = remoteService;
        }

        protected ICommand createCommand(IProgressMonitor monitor) throws CoreException {
            String version = System.getProperty(SYS_VERSION);
            String id = LocalNetworkSharing.getDefault().getSharingService().getLocalLibrary().getContactID();
            Attributes data = new Attributes();
            data.with("version", version);
            data.with("contact-id", id);
            return new Command("sharing.core.xmind.org", HANDSHAKE_PREFIX, data, null, null);
        }

        protected IStatus executeCommand(IProgressMonitor sendCommandMonitor, ICommand command) {
            IStatus status = super.executeCommand(sendCommandMonitor, command);
            if (status == null || status.getSeverity() == 4) {
                LocalNetworkSharing.log(status);
                status = Status.CANCEL_STATUS;
            }
            return status;
        }

        public IStatus consumeReturnValue(IProgressMonitor monitor, IStatus returnValue) {
            if (returnValue == null || !returnValue.isOK() || !(returnValue instanceof ReturnValue)) {
                return returnValue;
            }
            Attributes p = ((ReturnValue)returnValue).getAttributes();
            String libraryName = p.get("name");
            String contactID = p.get("contact-id");
            RemoteSharedLibrary remoteLibrary = new RemoteSharedLibrary(this.remoteService, libraryName);
            remoteLibrary.setContactID(contactID);
            ArrayMapper mapsReader = new ArrayMapper(p.getRawMap(), "maps");
            ArrayList<ISharedMap> maps = new ArrayList<ISharedMap>(mapsReader.getSize());
            while (mapsReader.hasNext()) {
                mapsReader.next();
                String mapID = (String)mapsReader.get("id");
                String mapName = (String)mapsReader.get("name");
                String thumbnailData = (String)mapsReader.get("thumbnail");
                String missing = (String)mapsReader.get("missing");
                long modifiedTime = 0L;
                String time = (String)mapsReader.get("modified-time");
                if (time != null) {
                    modifiedTime = Long.parseLong(time);
                }
                RemoteSharedMap map = new RemoteSharedMap(this.remoteService, remoteLibrary, mapID, mapName, Base64.base64ToByteArray(thumbnailData), Boolean.parseBoolean(missing));
                map.setResourceModifiedTime(modifiedTime);
                maps.add(map);
            }
            remoteLibrary.addMaps(maps);
            LocalNetworkSharingService.this.addRemoteLibrary(remoteLibrary);
            return returnValue;
        }
    }
}

