/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.texteditor.MEmbeddedEditor;
import org.xmind.ui.util.NumberUtils;
import org.xmind.ui.viewers.SWTUtils;

public class DurationEditor
extends MEmbeddedEditor
implements Listener {
    private Text dayInput;
    private Text hourInput;

    public DurationEditor(Composite parent) {
        super(parent);
        this.getButton().getControl().addListener(1, (Listener)this);
    }

    protected void createEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        this.createDayInput(composite);
        this.createHourInput(composite);
    }

    private void createDayInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)gridLayout);
        this.dayInput = new Text(composite, 2052);
        this.dayInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.dayInput.addListener(31, (Listener)this);
        this.dayInput.addListener(14, (Listener)this);
        this.dayInput.addListener(16, (Listener)this);
        this.dayInput.addListener(1, (Listener)this);
        Label label = new Label(composite, 0);
        label.setText(TaskMessages.DurationDays_label);
        label.setBackground(composite.getBackground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
    }

    private void createHourInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)gridLayout);
        this.hourInput = new Text(composite, 2052);
        this.hourInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.hourInput.addListener(31, (Listener)this);
        this.hourInput.addListener(14, (Listener)this);
        this.hourInput.addListener(16, (Listener)this);
        this.hourInput.addListener(1, (Listener)this);
        Label label = new Label(composite, 0);
        label.setText(TaskMessages.DurationHours_label);
        label.setBackground(composite.getBackground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
    }

    public void handleEvent(Event event) {
        if (event.type == 31) {
            if (event.detail == 2) {
                this.cancelEditing();
            }
        } else if (event.type == 14) {
            this.endEditing();
        } else if (event.type == 16) {
            this.endEditingWhenFocusOut();
        } else if (event.type == 1) {
            boolean onButton;
            if (event.widget instanceof Control && !((Control)event.widget).isEnabled()) {
                return;
            }
            boolean bl = onButton = event.widget == this.getButton().getControl();
            if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000001)) {
                if (event.widget == this.dayInput || onButton) {
                    this.increaseDays();
                } else {
                    this.increaseHours();
                }
                if (onButton) {
                    this.fireApplyEditorValue();
                }
            } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000002)) {
                if (event.widget == this.dayInput || onButton) {
                    this.decreaseDays();
                } else {
                    this.decreaseHours();
                }
                if (onButton) {
                    this.fireApplyEditorValue();
                }
            } else if (onButton) {
                if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)131072, (int)0x1000001)) {
                    this.increaseHours();
                    this.fireApplyEditorValue();
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)131072, (int)0x1000002)) {
                    this.decreaseHours();
                    this.fireApplyEditorValue();
                }
            }
        }
    }

    protected void decreaseHours() {
        int hours = this.getHours() - 1;
        if (hours < 0) {
            int days = this.getDays();
            if (days > 0) {
                this.setDays(days - 1);
                this.setHours(hours + 24);
            } else {
                this.setHours(0);
            }
        } else {
            this.setHours(hours);
        }
    }

    protected void increaseHours() {
        int hours = this.getHours() + 1;
        if (hours > 23) {
            this.setDays(this.getDays() + 1);
            this.setHours(hours - 24);
        } else {
            this.setHours(hours);
        }
    }

    private void increaseDays() {
        this.setDays(this.getDays() + 1);
    }

    private void decreaseDays() {
        this.setDays(Math.max(0, this.getDays() - 1));
    }

    protected void setEditorFocus() {
        this.dayInput.setFocus();
        this.dayInput.setSelection(this.dayInput.getText().length(), this.dayInput.getText().length());
    }

    public void setDays(int days) {
        this.dayInput.setText(String.valueOf(days));
    }

    public int getDays() {
        return NumberUtils.safeParseInt((String)this.dayInput.getText(), (int)0);
    }

    public void setHours(int hours) {
        this.hourInput.setText(String.valueOf(hours));
    }

    public int getHours() {
        return NumberUtils.safeParseInt((String)this.hourInput.getText(), (int)0);
    }
}

